/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.html.HtmlAttributeNode;
import com.google.template.soy.html.HtmlCloseTagNode;
import com.google.template.soy.html.HtmlDefinitions;
import com.google.template.soy.html.HtmlOpenTagEndNode;
import com.google.template.soy.html.HtmlOpenTagNode;
import com.google.template.soy.html.HtmlOpenTagStartNode;
import com.google.template.soy.html.HtmlPrintNode;
import com.google.template.soy.html.HtmlTextNode;
import com.google.template.soy.html.HtmlVoidTagNode;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenDirectivePluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.shared.internal.CodeBuilder;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import java.util.List;
import java.util.Map;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final SoyErrorKind PRINT_ATTR_INVALID_KIND = SoyErrorKind.of("Cannot have a print statement in an attributes list of kind {0}, it must be of kind attributes.");
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";

    @Inject
    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor, SoyTypeOps typeOps) {
        super(jsSrcOptions, jsExprTranslator, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, genDirectivePluginRequiresVisitor, typeOps);
    }

    @Override
    protected CodeBuilder<JsExpr> createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        super.addCodeToRequireGeneralDeps(soyFile);
        this.getJsCodeBuilder().appendLine("var IncrementalDom = goog.require('incrementaldom');").appendLine("var ie_open = IncrementalDom.elementOpen;").appendLine("var ie_close = IncrementalDom.elementClose;").appendLine("var ie_void = IncrementalDom.elementVoid;").appendLine("var ie_open_start = IncrementalDom.elementOpenStart;").appendLine("var ie_open_end = IncrementalDom.elementOpenEnd;").appendLine("var itext = IncrementalDom.text;").appendLine("var iattr = IncrementalDom.attr;");
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (node.getContentKind() == SanitizedContent.ContentKind.TEXT) {
            return "string";
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.getJsCodeBuilder().setContentKind(node.getContentKind());
        super.visitTemplateNode(node);
    }

    @Override
    protected void generateFunctionBody(TemplateNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = this.isTextContent(node.getContentKind());
        this.localVarTranslations.push(Maps.newHashMap());
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("var output = '';");
            jsCodeBuilder.pushOutputVar("output");
        }
        this.genParamTypeChecks(node);
        this.visitChildren(node);
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("return output;");
            jsCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind prevContentKind = jsCodeBuilder.getContentKind();
        this.localVarTranslations.push(Maps.newHashMap());
        jsCodeBuilder.pushOutputVar(generatedVarName);
        jsCodeBuilder.setContentKind(node.getContentKind());
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        switch (node.getContentKind()) {
            case HTML: 
            case ATTRIBUTES: {
                jsCodeBuilder.appendLine("var " + generatedVarName, " = function() {");
                jsCodeBuilder.increaseIndent();
                this.visitChildren(node);
                jsCodeBuilder.decreaseIndent();
                jsCodeBuilder.appendLine("};");
                break;
            }
            default: {
                jsCodeBuilder.appendLine("var ", generatedVarName, " = '';");
                this.visitChildren(node);
            }
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        ((Map)this.localVarTranslations.peek()).put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        Preconditions.checkState((boolean)(node instanceof CallBasicNode), (Object)"Delegate template calls not yet supported for Incremental DOM.");
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        JsExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations, this.templateAliases, this.errorReporter);
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        String templateName = ((CallBasicNode)node).getCalleeName();
        SanitizedContent.ContentKind currentContentKind = jsCodeBuilder.getContentKind();
        SanitizedContent.ContentKind callContentKind = this.templateRegistry.getBasicTemplate(templateName).getContentKind();
        if (this.isTextContent(currentContentKind)) {
            jsCodeBuilder.addToOutputVar((List<? extends JsExpr>)ImmutableList.of((Object)callExpr));
        } else if (this.isTextContent(callContentKind)) {
            jsCodeBuilder.appendLine("itext(", callExpr.getText(), ");");
        } else {
            jsCodeBuilder.appendLine(callExpr.getText() + ";");
        }
    }

    private boolean isTextContent(SanitizedContent.ContentKind contentKind) {
        return contentKind != SanitizedContent.ContentKind.HTML && contentKind != SanitizedContent.ContentKind.ATTRIBUTES;
    }

    private void printAttributes(ParentNode<HtmlAttributeNode> parentNode) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        List<HtmlAttributeNode> attributes = parentNode.getChildren();
        if (!attributes.isEmpty()) {
            jsCodeBuilder.append(", null");
            jsCodeBuilder.increaseIndent();
            jsCodeBuilder.appendLineEnd(",");
            this.printAttributeList(attributes);
            jsCodeBuilder.decreaseIndent();
        }
    }

    private void printAttributeValues(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        List children = node.getChildren();
        if (children.isEmpty()) {
            jsCodeBuilder.append("''");
        } else {
            Preconditions.checkState((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(node), (Object)"Attribute values that cannot be evalutated to simple expressions is not yet supported for Incremental DOM code generation");
            jsCodeBuilder.addToOutput(this.genJsExprsVisitor.execOnChildren(node));
        }
    }

    private void printAttributeList(List<HtmlAttributeNode> attributes) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        HtmlAttributeNode lastAttribute = attributes.get(attributes.size() - 1);
        jsCodeBuilder.increaseIndent();
        for (HtmlAttributeNode htmlAttributeNode : attributes) {
            jsCodeBuilder.appendLineStart("'", htmlAttributeNode.getName(), "', ");
            this.printAttributeValues(htmlAttributeNode);
            if (htmlAttributeNode == lastAttribute) continue;
            jsCodeBuilder.appendLineEnd(",");
        }
        jsCodeBuilder.decreaseIndent();
    }

    private void emitClose(String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.decreaseIndent();
        jsCodeBuilder.appendLine("ie_close('", tagName, "');");
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLineStart("iattr('", node.getName(), "', ");
        this.printAttributeValues(node);
        jsCodeBuilder.appendLineEnd(");");
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLineStart("ie_open('", node.getTagName(), "', null");
        this.printAttributes(node);
        jsCodeBuilder.appendLineEnd(");");
        jsCodeBuilder.increaseIndent();
        if (HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        if (!HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Override
    protected void visitHtmlOpenTagStartNode(HtmlOpenTagStartNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLine("ie_open_start('", node.getTagName(), "');");
        jsCodeBuilder.increaseIndentTwice();
    }

    @Override
    protected void visitHtmlOpenTagEndNode(HtmlOpenTagEndNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.decreaseIndentTwice();
        jsCodeBuilder.appendLine("ie_open_end();");
        jsCodeBuilder.increaseIndent();
        if (HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Override
    protected void visitHtmlVoidTagNode(HtmlVoidTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLineStart("ie_void('", node.getTagName(), "', null");
        this.printAttributes(node);
        jsCodeBuilder.appendLineEnd(");");
    }

    @Override
    protected void visitHtmlTextNode(HtmlTextNode node) {
        this.getJsCodeBuilder().appendLine("itext('", node.getRawText(), "');");
    }

    @Override
    protected void visitHtmlPrintNode(HtmlPrintNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        PrintNode printNode = node.getPrintNode();
        ExprUnion exprUnion = printNode.getExprUnion();
        ExprRootNode expr = exprUnion.getExpr();
        List<ExprNode> exprNodes = expr.getChildren();
        ExprNode firstNode = exprNodes.get(0);
        SoyType.Kind firstKind = firstNode.getType().getKind();
        switch (node.getContext()) {
            case HTML_TAG: {
                if (firstKind == SoyType.Kind.ATTRIBUTES) {
                    VarRefNode varRefNode = (VarRefNode)firstNode;
                    String varName = JsSrcUtils.getVariableName(varRefNode.getName(), this.localVarTranslations);
                    jsCodeBuilder.appendLine(varName, "();");
                    break;
                }
                this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_KIND, new Object[]{firstKind});
                break;
            }
            case HTML_PCDATA: {
                if (firstKind == SoyType.Kind.HTML) {
                    VarRefNode varRefNode = (VarRefNode)firstNode;
                    String varName = JsSrcUtils.getVariableName(varRefNode.getName(), this.localVarTranslations);
                    jsCodeBuilder.appendLine(varName, "();");
                    break;
                }
                jsCodeBuilder.appendLineStart("itext(");
                for (JsExpr jsExpr : this.genJsExprsVisitor.exec(printNode)) {
                    jsCodeBuilder.append(jsExpr.getText());
                }
                jsCodeBuilder.appendLineEnd(");");
            }
        }
    }
}

