/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.ArrayList;
import java.util.List;

public final class ErrorReporterImpl
implements ErrorReporter {
    private final List<SoyError> errors = new ArrayList<SoyError>();
    private final SoyError.Factory errorFactory;

    public ErrorReporterImpl() {
        this.errorFactory = SoyError.DEFAULT_FACTORY;
    }

    public ErrorReporterImpl(SoyError.Factory defaultFactory) {
        this.errorFactory = defaultFactory;
    }

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        this.errors.add(this.errorFactory.create(sourceLocation, error, args));
    }

    @Override
    public ErrorReporter.Checkpoint checkpoint() {
        return new CheckpointImpl(this.errors.size());
    }

    @Override
    public boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        return this.errors.size() > ((CheckpointImpl)checkpoint).numErrors;
    }

    public Iterable<SoyError> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private static final class CheckpointImpl
    implements ErrorReporter.Checkpoint {
        private final int numErrors;

        private CheckpointImpl(int numErrors) {
            this.numErrors = numErrors;
        }
    }
}

