/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.ProtoUtils;
import java.util.Set;
import javax.annotation.Nullable;

public final class SoyProtoType
implements SoyType {
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, Field> fields;

    SoyProtoType(SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.typeDescriptor = descriptor;
        this.fields = Field.getFieldsForType(typeRegistry, descriptor, extensions);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        Descriptors.Descriptor descriptor = this.typeDescriptor;
        while (descriptor.getContainingType() != null) {
            descriptor = descriptor.getContainingType();
        }
        return JavaQualifiedNames.getQualifiedName(descriptor) + ".getDescriptor()";
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        return ((Field)this.fields.get((Object)fieldName)).getDescriptor();
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        Field field = (Field)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)this.typeDescriptor);
            }
            case TOFU: 
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.typeDescriptor.getFullName();
    }

    public boolean shouldCheckFieldPresenceToEmulateJspbNullability(String fieldName) {
        return ((Field)this.fields.get((Object)fieldName)).shouldCheckFieldPresenceToEmulateJspbNullability();
    }
}

