/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.proto.ProtoUtils;
import com.google.template.soy.types.proto.SafeStringTypes;
import com.google.template.soy.types.proto.SoyProtoValueImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class FieldInterpreter {
    private static final FieldInterpreter BYTES = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return StringData.forValue(BaseEncoding.base64().encode(((ByteString)field).toByteArray()));
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)field.stringValue()));
        }
    };
    private static final FieldInterpreter BOOL = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return BooleanData.forValue((Boolean)field);
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return BoolType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.booleanValue();
        }
    };
    private static final FieldInterpreter INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return IntegerData.forValue(((Number)field).longValue());
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return IntType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return Ints.saturatedCast((long)field.longValue());
        }
    };
    private static final FieldInterpreter UNSIGNED_INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return IntegerData.forValue(UnsignedInts.toLong((int)((Number)field).intValue()));
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return IntType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return UnsignedInts.saturatedCast((long)field.longValue());
        }
    };
    private static final FieldInterpreter LONG_AS_INT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return IntegerData.forValue((Long)field);
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return IntType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.longValue();
        }
    };
    private static final FieldInterpreter LONG_AS_STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return Long.parseLong(field.stringValue());
        }
    };
    private static final FieldInterpreter UNSIGNEDLONG_AS_STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return StringData.forValue(UnsignedLongs.toString((long)((Long)field)));
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return UnsignedLongs.parseUnsignedLong((String)field.stringValue());
        }
    };
    private static final FieldInterpreter FLOAT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return FloatData.forValue(((Float)field).floatValue());
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return FloatType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return Float.valueOf((float)field.floatValue());
        }
    };
    private static final FieldInterpreter DOUBLE_AS_FLOAT = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return FloatData.forValue((Double)field);
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return FloatType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.floatValue();
        }
    };
    private static final FieldInterpreter STRING = new FieldInterpreter(){

        @Override
        public SoyValueProvider soyFromProto(Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public SoyType type(SoyTypeRegistry registry) {
            return StringType.getInstance();
        }

        @Override
        Object protoFromSoy(SoyValue field) {
            return field.stringValue();
        }
    };

    static FieldInterpreter create(Descriptors.FieldDescriptor fieldDescriptor) {
        FieldInterpreter field = FieldInterpreter.getScalarType(fieldDescriptor);
        if (fieldDescriptor.isMapField()) {
            List mapFields = fieldDescriptor.getMessageType().getFields();
            Preconditions.checkState((mapFields.size() == 2 ? 1 : 0) != 0, (Object)"proto representation of map fields changed");
            FieldInterpreter keyField = FieldInterpreter.getScalarType((Descriptors.FieldDescriptor)mapFields.get(0));
            FieldInterpreter valueField = FieldInterpreter.getScalarType((Descriptors.FieldDescriptor)mapFields.get(1));
            return FieldInterpreter.getMapType(keyField, valueField, fieldDescriptor);
        }
        if (fieldDescriptor.isRepeated()) {
            return ProtoUtils.hasJsMapKey(fieldDescriptor) ? FieldInterpreter.getJspbMapType(field, fieldDescriptor) : FieldInterpreter.getListType(field);
        }
        return field;
    }

    private static FieldInterpreter getListType(final FieldInterpreter local) {
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider soyFromProto(Object field) {
                List entries = (List)field;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object item : entries) {
                    builder.add((Object)local.soyFromProto(item));
                }
                return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type(SoyTypeRegistry typeRegistry) {
                return typeRegistry.getOrCreateListType(local.type(typeRegistry));
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                SoyList list = (SoyList)field;
                ArrayList<Object> uninterpretedValues = new ArrayList<Object>();
                for (SoyValue soyValue : list.asResolvedJavaList()) {
                    uninterpretedValues.add(local.protoFromSoy(soyValue));
                }
                return uninterpretedValues;
            }
        };
    }

    private static FieldInterpreter getMapType(final FieldInterpreter keyField, final FieldInterpreter valueField, final Descriptors.FieldDescriptor fieldDescriptor) {
        final Descriptors.Descriptor messageDescriptor = fieldDescriptor.getMessageType();
        final Descriptors.FieldDescriptor keyDescriptor = (Descriptors.FieldDescriptor)messageDescriptor.getFields().get(0);
        final Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)messageDescriptor.getFields().get(1);
        return new FieldInterpreter(){

            @Override
            SoyType type(SoyTypeRegistry registry) {
                return registry.getOrCreateMapType(keyField.type(registry), valueField.type(registry));
            }

            @Override
            SoyValueProvider soyFromProto(Object field) {
                List entries = (List)field;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Message message : entries) {
                    String key = (String)message.getField(keyDescriptor);
                    builder.put((Object)key, (Object)valueField.soyFromProto(message.getField(valueDescriptor)));
                }
                return SoyMapImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build());
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                SoyNewMap map = (SoyNewMap)field;
                ImmutableList.Builder mapEntries = ImmutableList.builder();
                Map<String, ? extends SoyValue> resolvedMap = map.asResolvedJavaStringMap();
                DynamicMessage.Builder defaultInstance = DynamicMessage.newBuilder((Descriptors.Descriptor)messageDescriptor.getContainingType());
                for (String key : resolvedMap.keySet()) {
                    Message.Builder entryBuilder = defaultInstance.newBuilderForField(fieldDescriptor);
                    entryBuilder.setField(keyDescriptor, (Object)key);
                    entryBuilder.setField(valueDescriptor, valueField.protoFromSoy(resolvedMap.get(key)));
                    mapEntries.add((Object)entryBuilder.build());
                }
                return mapEntries.build();
            }
        };
    }

    private static FieldInterpreter getJspbMapType(final FieldInterpreter scalarImpl, Descriptors.FieldDescriptor fieldDescriptor) {
        String keyFieldName = ProtoUtils.getJsMapKeyFieldName(fieldDescriptor);
        final Descriptors.FieldDescriptor keyDescriptor = fieldDescriptor.getMessageType().findFieldByName(keyFieldName);
        if (keyDescriptor == null) {
            throw new IllegalArgumentException("Cannot find field with name \"" + keyFieldName + "\".");
        }
        if (keyDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.STRING || keyDescriptor.isRepeated()) {
            throw new IllegalArgumentException("\"" + keyFieldName + "\" must be an optional/required string field.");
        }
        return new FieldInterpreter(){

            @Override
            public SoyValueProvider soyFromProto(Object field) {
                List entries = (List)field;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Message message : entries) {
                    String key = (String)message.getField(keyDescriptor);
                    if (key.isEmpty()) continue;
                    builder.put((Object)key, (Object)scalarImpl.soyFromProto(message));
                }
                return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build());
            }

            @Override
            public SoyType type(SoyTypeRegistry registry) {
                return registry.getOrCreateLegacyObjectMapType(StringType.getInstance(), scalarImpl.type(registry));
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                throw new UnsupportedOperationException("assigning to mapkey fields is not currently supported");
            }
        };
    }

    private static FieldInterpreter getScalarType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (ProtoUtils.hasJsType(fieldDescriptor)) {
            DescriptorProtos.FieldOptions.JSType jsType = ProtoUtils.getJsType(fieldDescriptor);
            switch (jsType) {
                case JS_NORMAL: 
                case JS_NUMBER: {
                    return LONG_AS_INT;
                }
                case JS_STRING: {
                    if (ProtoUtils.isUnsigned(fieldDescriptor)) {
                        return UNSIGNEDLONG_AS_STRING;
                    }
                    return LONG_AS_STRING;
                }
            }
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                return BOOL;
            }
            case DOUBLE: {
                return DOUBLE_AS_FLOAT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case BYTES: {
                return BYTES;
            }
            case GROUP: {
                throw new UnsupportedOperationException("soy doesn't support proto groups: " + fieldDescriptor.getFullName());
            }
            case INT64: {
                return LONG_AS_INT;
            }
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return INT;
            }
            case UINT32: 
            case FIXED32: {
                return UNSIGNED_INT;
            }
            case FIXED64: 
            case SINT64: 
            case SFIXED64: 
            case UINT64: {
                throw new IllegalArgumentException(fieldDescriptor.getFullName() + ": 64-bit integer types are not supported.  Instead, add [(jspb.jstype) = INT52] to the field.");
            }
            case ENUM: {
                return FieldInterpreter.enumTypeField(fieldDescriptor);
            }
            case MESSAGE: {
                SanitizedType sanitizedType = SafeStringTypes.getSafeStringType(fieldDescriptor.getMessageType());
                if (sanitizedType != null) {
                    return FieldInterpreter.safeStringTypeField(sanitizedType, fieldDescriptor.getMessageType());
                }
                return FieldInterpreter.messageTypeField(fieldDescriptor.getMessageType());
            }
            case STRING: {
                return STRING;
            }
        }
        throw new AssertionError((Object)"Unexpected field type in proto");
    }

    private static final FieldInterpreter enumTypeField(final Descriptors.FieldDescriptor fieldDescriptor) {
        final Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
        return new FieldInterpreter(){

            @Override
            public SoyType type(SoyTypeRegistry registry) {
                return registry.getType(fieldDescriptor.getEnumType().getFullName());
            }

            @Override
            public SoyValueProvider soyFromProto(Object field) {
                int value = field instanceof ProtocolMessageEnum ? ((ProtocolMessageEnum)field).getNumber() : ((Descriptors.EnumValueDescriptor)field).getNumber();
                return IntegerData.forValue(value);
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                int value = field.integerValue();
                if (fieldDescriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                    return enumDescriptor.findValueByNumberCreatingIfUnknown(value);
                }
                return enumDescriptor.findValueByNumber(value);
            }
        };
    }

    private static final FieldInterpreter safeStringTypeField(final SanitizedType type, final Descriptors.Descriptor fieldType) {
        return new FieldInterpreter(){

            @Override
            public SoyType type(SoyTypeRegistry registry) {
                return type;
            }

            @Override
            public SoyValueProvider soyFromProto(Object field) {
                return SafeStringTypes.convertToSoyValue(field);
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                return SafeStringTypes.convertToProto((SanitizedContent)field, fieldType.getFullName());
            }
        };
    }

    private static final FieldInterpreter messageTypeField(final Descriptors.Descriptor messageDescriptor) {
        return new FieldInterpreter(){

            @Override
            public SoyType type(SoyTypeRegistry registry) {
                return registry.getType(messageDescriptor.getFullName());
            }

            @Override
            public SoyValueProvider soyFromProto(Object field) {
                return SoyProtoValueImpl.create((Message)field);
            }

            @Override
            Object protoFromSoy(SoyValue field) {
                return ((SoyProtoValue)field).getProto();
            }
        };
    }

    private FieldInterpreter() {
    }

    abstract SoyType type(SoyTypeRegistry var1);

    abstract SoyValueProvider soyFromProto(Object var1);

    abstract Object protoFromSoy(SoyValue var1);
}

