/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.types.ast.AutoValue_RecordTypeNode;
import com.google.template.soy.types.ast.AutoValue_RecordTypeNode_Property;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

public abstract class RecordTypeNode
extends TypeNode {
    public static RecordTypeNode create(SourceLocation sourceLocation, Iterable<Property> properties) {
        return new AutoValue_RecordTypeNode(sourceLocation, (ImmutableList<Property>)ImmutableList.copyOf(properties));
    }

    RecordTypeNode() {
    }

    public abstract ImmutableList<Property> properties();

    @Override
    public String toString() {
        if (this.properties().size() < 3) {
            return "[" + Joiner.on((String)", ").join(this.properties()) + "]";
        }
        return "[\n  " + Joiner.on((String)",\n  ").join(this.properties()) + "\n]";
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static abstract class Property {
        public static Property create(SourceLocation nameLocation, String name, TypeNode type) {
            return new AutoValue_RecordTypeNode_Property(nameLocation, name, type);
        }

        Property() {
        }

        public abstract SourceLocation nameLocation();

        public abstract String name();

        public abstract TypeNode type();

        public String toString() {
            return this.name() + ": " + this.type();
        }
    }
}

