/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public final class VeLogNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.StatementNode,
SoyNode.BlockNode {
    @Nullable
    private final ExprRootNode dataExpr;
    @Nullable
    private final ExprRootNode logonlyExpr;
    private final Identifier name;
    @Nullable
    private Long loggingId;

    public VeLogNode(int id, SourceLocation location, Identifier name, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, "velog");
        this.name = (Identifier)Preconditions.checkNotNull((Object)name);
        ExprRootNode configExpr = null;
        ExprRootNode logonlyExpr = null;
        block8: for (CommandTagAttribute attr : attributes) {
            switch (attr.getName().identifier()) {
                case "logonly": {
                    logonlyExpr = new ExprRootNode(attr.valueAsExpr(errorReporter));
                    continue block8;
                }
                case "data": {
                    configExpr = new ExprRootNode(attr.valueAsExpr(errorReporter));
                    continue block8;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attr.getName().identifier(), "velog", ImmutableList.of((Object)"logonly", (Object)"data"));
        }
        this.dataExpr = configExpr;
        this.logonlyExpr = logonlyExpr;
    }

    private VeLogNode(VeLogNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.dataExpr = orig.dataExpr == null ? null : orig.dataExpr.copy(copyState);
        this.logonlyExpr = orig.logonlyExpr == null ? null : orig.logonlyExpr.copy(copyState);
        this.loggingId = orig.loggingId;
    }

    public Identifier getName() {
        return this.name;
    }

    @Nullable
    public Long getLoggingId() {
        return this.loggingId;
    }

    @Nullable
    public ExprRootNode getConfigExpression() {
        return this.dataExpr;
    }

    @Nullable
    public ExprRootNode getLogonlyExpression() {
        return this.logonlyExpr;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.VE_LOG_NODE;
    }

    @Override
    public String getCommandText() {
        return this.name.identifier() + (this.dataExpr != null ? " data=\"" + this.dataExpr.toSourceString() + "\"" : "") + (this.logonlyExpr != null ? " logonly=\"" + this.logonlyExpr.toSourceString() + "\"" : "");
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public VeLogNode copy(CopyState copyState) {
        return new VeLogNode(this, copyState);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.dataExpr != null) {
            builder.add((Object)this.dataExpr);
        }
        if (this.logonlyExpr != null) {
            builder.add((Object)this.logonlyExpr);
        }
        return builder.build();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/velog}");
        return sb.toString();
    }

    public void setLoggingId(long id) {
        this.loggingId = id;
    }
}

