/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;

public class TemplateDelegateNodeBuilder
extends TemplateNodeBuilder {
    private static final SoyErrorKind INVALID_VARIANT_EXPR = SoyErrorKind.of("Invalid variant expression (must be a string literal containing an identifier or global expression).", new SoyErrorKind.StyleAllowance[0]);
    private String delTemplateName;
    private String delTemplateVariant = null;
    private ExprRootNode delTemplateVariantExpr = null;
    private TemplateDelegateNode.DelTemplateKey delTemplateKey;
    private TemplateNode.Priority delPriority;

    public TemplateDelegateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateDelegateNodeBuilder setId(int id) {
        return (TemplateDelegateNodeBuilder)super.setId(id);
    }

    @Override
    public TemplateDelegateNodeBuilder setSourceLocation(SourceLocation location) {
        return (TemplateDelegateNodeBuilder)super.setSourceLocation(location);
    }

    @Override
    public TemplateNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.delTemplateName = templateName.identifier();
        this.delTemplateVariant = "";
        block6: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            if (COMMON_ATTRIBUTE_NAMES.contains((Object)name.identifier())) continue;
            switch (name.identifier()) {
                case "variant": {
                    this.delTemplateVariant = null;
                    ExprNode variantExpr = attribute.valueAsExpr(this.errorReporter);
                    if (variantExpr instanceof StringNode) {
                        this.delTemplateVariant = ((StringNode)variantExpr).getValue();
                        TemplateDelegateNode.verifyVariantName(this.delTemplateVariant, attribute.getValueLocation());
                        continue block6;
                    }
                    if (variantExpr instanceof GlobalNode) {
                        this.delTemplateVariantExpr = new ExprRootNode(variantExpr);
                        this.templateNameForUserMsgs = this.delTemplateName + ":" + ((GlobalNode)variantExpr).getName();
                        continue block6;
                    }
                    this.errorReporter.report(attribute.getValueLocation(), INVALID_VARIANT_EXPR, new Object[0]);
                    continue block6;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "deltemplate", ImmutableList.builder().addAll((Iterable)COMMON_ATTRIBUTE_NAMES).add((Object)"variant").build());
        }
        if (this.delTemplateVariant != null) {
            this.delTemplateKey = TemplateDelegateNode.DelTemplateKey.create(this.delTemplateName, this.delTemplateVariant);
            this.templateNameForUserMsgs = this.delTemplateKey.toString();
        }
        this.delPriority = this.soyFileHeaderInfo.priority;
        this.genInternalTemplateNameHelper(templateName.location());
        return this;
    }

    public TemplateDelegateNodeBuilder setCmdTextInfo(String delTemplateName, String delTemplateVariant, TemplateNode.Priority delPriority, AutoescapeMode autoescapeMode, SanitizedContentKind contentKind, ImmutableList<String> requiredCssNamespaces) {
        Preconditions.checkState((this.sourceLocation != null ? 1 : 0) != 0);
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delTemplateName));
        Preconditions.checkArgument((delTemplateVariant.length() == 0 || BaseUtils.isIdentifier(delTemplateVariant) ? 1 : 0) != 0);
        Preconditions.checkArgument((contentKind != null == (autoescapeMode == AutoescapeMode.STRICT) ? 1 : 0) != 0);
        this.delTemplateName = delTemplateName;
        this.delTemplateVariant = delTemplateVariant;
        this.delTemplateKey = TemplateDelegateNode.DelTemplateKey.create(delTemplateName, delTemplateVariant);
        this.templateNameForUserMsgs = this.delTemplateKey.toString();
        this.delPriority = delPriority;
        this.setAutoescapeInfo(autoescapeMode, contentKind, this.sourceLocation);
        this.setRequiredCssNamespaces(requiredCssNamespaces);
        String cmdText = delTemplateName + (delTemplateVariant.length() == 0 ? "" : " variant=\"" + delTemplateVariant + "\"") + " autoescape=\"" + autoescapeMode.getAttributeValue() + "\"";
        if (contentKind != null) {
            cmdText = cmdText + " kind=\"" + contentKind.asAttributeValue() + '\"';
        }
        if (!requiredCssNamespaces.isEmpty()) {
            cmdText = cmdText + " requirecss=\"" + Joiner.on((String)", ").join(requiredCssNamespaces) + "\"";
        }
        this.cmdText = cmdText;
        this.genInternalTemplateNameHelper(this.sourceLocation);
        return this;
    }

    private void genInternalTemplateNameHelper(SourceLocation nameLocation) {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        String delPackageTemplateAndVariantStr = (this.soyFileHeaderInfo.delPackageName == null ? "" : this.soyFileHeaderInfo.delPackageName) + "_" + this.delTemplateName.replace('.', '_') + "_" + (this.delTemplateVariant == null ? this.delTemplateVariantExpr.toSourceString() : this.delTemplateVariant);
        delPackageTemplateAndVariantStr = delPackageTemplateAndVariantStr.replace('.', '_');
        String generatedPartialTemplateName = ".__deltemplate_" + delPackageTemplateAndVariantStr;
        String generatedTemplateName = this.soyFileHeaderInfo.namespace + generatedPartialTemplateName;
        this.setTemplateNames(generatedTemplateName, nameLocation, generatedPartialTemplateName);
    }

    @Override
    public TemplateDelegateNodeBuilder setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        return (TemplateDelegateNodeBuilder)super.setSoyDoc(soyDoc, soyDocLocation);
    }

    @Override
    public TemplateDelegateNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        return (TemplateDelegateNodeBuilder)super.addParams(allParams);
    }

    @Override
    public TemplateDelegateNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateDelegateNode(this, this.soyFileHeaderInfo, this.delTemplateName, this.delTemplateVariant, this.delTemplateVariantExpr, this.delTemplateKey, this.delPriority, (ImmutableList<TemplateParam>)this.params);
    }
}

