/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SoyTreeUtils {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    private SoyTreeUtils() {
    }

    @SafeVarargs
    public static boolean hasNodesOfType(Node node, Class<? extends Node> ... types) {
        class Visitor
        implements NodeVisitor<Node, VisitDirective> {
            boolean found;
            final /* synthetic */ Class[] val$types;

            Visitor(Class[] classArray) {
                this.val$types = classArray;
            }

            @Override
            public VisitDirective exec(Node node) {
                for (Class type : this.val$types) {
                    if (!type.isInstance(node)) continue;
                    this.found = true;
                    return VisitDirective.ABORT;
                }
                return VisitDirective.CONTINUE;
            }
        }
        Visitor v = new Visitor(types);
        SoyTreeUtils.visitAllNodes(node, v);
        return v.found;
    }

    public static boolean hasHtmlNodes(Node node) {
        return SoyTreeUtils.hasNodesOfType(node, HtmlOpenTagNode.class, HtmlCloseTagNode.class, HtmlCommentNode.class, HtmlAttributeNode.class, HtmlAttributeValueNode.class);
    }

    public static void visitAllNodes(Node node, NodeVisitor<? super Node, VisitDirective> visitor) {
        Node current;
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        queue.add(node);
        block5: while ((current = (Node)queue.poll()) != null) {
            switch (visitor.exec(current)) {
                case ABORT: {
                    return;
                }
                case CONTINUE: {
                    if (current instanceof ParentNode) {
                        queue.addAll(((ParentNode)current).getChildren());
                    }
                    if (!(current instanceof SoyNode.ExprHolderNode)) continue block5;
                    queue.addAll((Collection<Node>)((SoyNode.ExprHolderNode)current).getExprList());
                    continue block5;
                }
                case SKIP_CHILDREN: {
                    continue block5;
                }
            }
            throw new AssertionError();
        }
    }

    public static <T extends Node> ImmutableList<T> getAllNodesOfType(Node rootSoyNode, final Class<T> classObject) {
        final ImmutableList.Builder matchedNodesBuilder = ImmutableList.builder();
        final boolean exploreExpressions = ExprNode.class.isAssignableFrom(classObject);
        SoyTreeUtils.visitAllNodes(rootSoyNode, (NodeVisitor<? super Node, VisitDirective>)new NodeVisitor<Node, VisitDirective>(){

            @Override
            public VisitDirective exec(Node node) {
                if (classObject.isInstance(node)) {
                    matchedNodesBuilder.add(classObject.cast(node));
                }
                if (!exploreExpressions && node instanceof ExprNode) {
                    return VisitDirective.SKIP_CHILDREN;
                }
                return VisitDirective.CONTINUE;
            }
        });
        return matchedNodesBuilder.build();
    }

    public static StringBuilder buildAstString(SoyNode.ParentSoyNode<?> node, int indent, StringBuilder sb) {
        for (SoyNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append('\n');
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            SoyTreeUtils.buildAstString((SoyNode.ParentSoyNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static StringBuilder buildAstStringWithPreview(SoyNode.ParentSoyNode<?> node, int indent, StringBuilder sb) {
        for (SoyNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append(": ").append(child.toSourceString()).append('\n');
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            SoyTreeUtils.buildAstString((SoyNode.ParentSoyNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, final AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
        SoyTreeUtils.visitAllNodes(node, (NodeVisitor<? super Node, VisitDirective>)new NodeVisitor<Node, VisitDirective>(){

            @Override
            public VisitDirective exec(Node node) {
                if (node instanceof SoyNode.ExprHolderNode) {
                    for (ExprRootNode expr : ((SoyNode.ExprHolderNode)node).getExprList()) {
                        exprNodeVisitor.exec(expr);
                    }
                } else if (node instanceof ExprNode) {
                    return VisitDirective.SKIP_CHILDREN;
                }
                return VisitDirective.CONTINUE;
            }
        });
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode, IdGenerator nodeIdGen) {
        SoyNode clone = origNode.copy(new CopyState());
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return (T)clone;
    }

    public static <T extends SoyNode> List<T> cloneListWithNewIds(List<T> origNodes, IdGenerator nodeIdGen) {
        Preconditions.checkNotNull(origNodes);
        ArrayList<SoyNode> clones = new ArrayList<SoyNode>(origNodes.size());
        for (SoyNode origNode : origNodes) {
            SoyNode clone = origNode.copy(new CopyState());
            new GenNewIdsVisitor(nodeIdGen).exec(clone);
            clones.add(clone);
        }
        return clones;
    }

    public static boolean isDescendantOf(SoyNode node, SoyNode ancestor) {
        while (node != null) {
            if (ancestor == node) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static String toSourceString(List<? extends Node> nodes) {
        ArrayList<String> strings = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            strings.add(node.toSourceString());
        }
        return COMMA_JOINER.join(strings);
    }

    private static class GenNewIdsVisitor
    extends AbstractNodeVisitor<SoyNode, Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visit(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    public static enum VisitDirective {
        SKIP_CHILDREN,
        ABORT,
        CONTINUE;

    }
}

