/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprRootNode expr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    @Nullable
    private HtmlContext htmlContext;

    public PrintNode(int id, SourceLocation location, boolean isImplicit, ExprNode expr, @Nullable CommandTagAttribute phname, ErrorReporter errorReporter) {
        super(id, location, isImplicit ? "" : "print");
        this.isImplicit = isImplicit;
        this.expr = new ExprRootNode(expr);
        if (phname == null) {
            this.userSuppliedPlaceholderName = null;
        } else if (phname.hasName("phname")) {
            this.userSuppliedPlaceholderName = phname.getValue();
        } else {
            errorReporter.report(phname.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, phname.getName().identifier(), "print", "phname");
            this.userSuppliedPlaceholderName = null;
        }
    }

    private PrintNode(PrintNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isImplicit = orig.isImplicit;
        this.expr = orig.expr.copy(copyState);
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.htmlContext = orig.htmlContext;
    }

    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlTransformVisitor"));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(this.expr.getRoot(), FALLBACK_BASE_PLACEHOLDER_NAME);
    }

    @Override
    public Object genSamenessKey() {
        return this.getCommandText();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public String getCommandText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr.toSourceString());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public PrintNode copy(CopyState copyState) {
        return new PrintNode(this, copyState);
    }
}

