/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;

public final class HtmlAttributeValueNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode {
    private final Quotes quotes;

    public HtmlAttributeValueNode(int id, SourceLocation location, Quotes quotes) {
        super(id, location);
        this.quotes = quotes;
    }

    private HtmlAttributeValueNode(HtmlAttributeValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.quotes = orig.quotes;
    }

    public Quotes getQuotes() {
        return this.quotes;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE;
    }

    @Override
    public SoyNode copy(CopyState copyState) {
        return new HtmlAttributeValueNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.quotes.qMark);
        this.appendSourceStringForChildren(sb);
        sb.append(this.quotes.qMark);
        return sb.toString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    public static enum Quotes {
        DOUBLE("\""),
        SINGLE("'"),
        NONE("");

        private final String qMark;

        private Quotes(String qMark) {
            this.qMark = qMark;
        }

        public String getQuotationCharacter() {
            return this.qMark;
        }
    }
}

