/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;
import javax.annotation.Nullable;

public final class CallDelegateNode
extends CallNode {
    private static final SoyErrorKind INVALID_VARIANT_EXPRESSION = SoyErrorKind.of("Invalid variant expression \"{0}\" in ''delcall'' (variant expression must evaluate to an identifier).", new SoyErrorKind.StyleAllowance[0]);
    private String delCalleeName;
    @Nullable
    private final ExprRootNode variantExpr;
    private final boolean allowEmptyDefault;
    @Nullable
    private ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheckByDelegate = null;

    public CallDelegateNode(int id, SourceLocation location, String delCalleeName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, "delcall", attributes, errorReporter);
        this.delCalleeName = delCalleeName;
        ExprRootNode variantExpr = null;
        boolean allowEmptyDefault = false;
        block11: for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": 
                case "phname": {
                    continue block11;
                }
                case "variant": {
                    ExprNode value = attr.valueAsExpr(errorReporter);
                    if (value instanceof StringNode) {
                        String variantStr = ((StringNode)value).getValue();
                        if (!BaseUtils.isIdentifier(variantStr)) {
                            errorReporter.report(location, INVALID_VARIANT_EXPRESSION, variantStr);
                        }
                    } else if (value instanceof ExprNode.PrimitiveNode) {
                        errorReporter.report(location, INVALID_VARIANT_EXPRESSION, value.toSourceString());
                    }
                    variantExpr = new ExprRootNode(value);
                    continue block11;
                }
                case "allowemptydefault": {
                    allowEmptyDefault = attr.valueAsEnabled(errorReporter);
                    continue block11;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, "call", ImmutableList.of((Object)"data", (Object)"phname", (Object)"variant", (Object)"allowemptydefault"));
        }
        this.variantExpr = variantExpr;
        this.allowEmptyDefault = allowEmptyDefault;
    }

    private CallDelegateNode(CallDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delCalleeName = orig.delCalleeName;
        this.variantExpr = orig.variantExpr != null ? orig.variantExpr.copy(copyState) : null;
        this.allowEmptyDefault = orig.allowEmptyDefault;
        this.paramsToRuntimeCheckByDelegate = orig.paramsToRuntimeCheckByDelegate;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    public void setDelCalleeName(String delCalleeName) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delCalleeName));
        this.delCalleeName = delCalleeName;
    }

    @Nullable
    public ExprRootNode getDelCalleeVariantExpr() {
        return this.variantExpr;
    }

    public void setParamsToRuntimeCheck(ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>> paramsToRuntimeCheck) {
        Preconditions.checkState((this.paramsToRuntimeCheckByDelegate == null ? 1 : 0) != 0);
        this.paramsToRuntimeCheckByDelegate = (ImmutableMap)Preconditions.checkNotNull(paramsToRuntimeCheck);
    }

    @Override
    public ImmutableList<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        if (this.paramsToRuntimeCheckByDelegate == null) {
            return callee.getParams();
        }
        ImmutableList params = (ImmutableList)this.paramsToRuntimeCheckByDelegate.get((Object)callee);
        if (params == null) {
            return callee.getParams();
        }
        return params;
    }

    public boolean allowEmptyDefault() {
        return this.allowEmptyDefault;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.delCalleeName);
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        if (this.getUserSuppliedPhName() != null) {
            commandText.append(" phname=\"").append(this.getUserSuppliedPhName()).append('\"');
        }
        if (this.variantExpr != null) {
            commandText.append(" variant=\"").append(this.variantExpr.toSourceString()).append('\"');
        }
        if (this.allowEmptyDefault) {
            commandText.append(" allowemptydefault=\"true\"");
        }
        return commandText.toString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder allExprs = ImmutableList.builder();
        if (this.variantExpr != null) {
            allExprs.add((Object)this.variantExpr);
        }
        allExprs.addAll(super.getExprList());
        return allExprs.build();
    }

    @Override
    public CallDelegateNode copy(CopyState copyState) {
        return new CallDelegateNode(this, copyState);
    }
}

