/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.proto.SoyProtoType;

final class TofuTypeChecks {
    TofuTypeChecks() {
    }

    static final boolean isInstance(SoyType type, SoyValue value) {
        switch (type.getKind()) {
            case ANY: 
            case UNKNOWN: {
                return true;
            }
            case ATTRIBUTES: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.ATTRIBUTES);
            }
            case CSS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.CSS);
            }
            case BOOL: {
                return value instanceof BooleanData;
            }
            case FLOAT: {
                return value instanceof FloatData;
            }
            case HTML: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.HTML);
            }
            case INT: {
                return value instanceof IntegerData;
            }
            case JS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.JS);
            }
            case LIST: {
                return value instanceof SoyList;
            }
            case MAP: {
                return value instanceof SoyNewMap;
            }
            case LEGACY_OBJECT_MAP: {
                return value instanceof SoyMap;
            }
            case NULL: {
                return value == NullData.INSTANCE || value == UndefinedData.INSTANCE;
            }
            case PROTO: {
                return value instanceof SoyProtoValue && ((SoyProtoValue)value).getProto().getDescriptorForType() == ((SoyProtoType)type).getDescriptor();
            }
            case PROTO_ENUM: {
                return value instanceof IntegerData;
            }
            case RECORD: {
                return value instanceof SoyRecord;
            }
            case STRING: {
                return value instanceof SoyString;
            }
            case TRUSTED_RESOURCE_URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
            }
            case UNION: {
                for (SoyType memberType : ((UnionType)type).getMembers()) {
                    if (!TofuTypeChecks.isInstance(memberType, value)) continue;
                    return true;
                }
                return false;
            }
            case URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.URI);
            }
        }
        throw new AssertionError((Object)("invalid type: " + type));
    }

    private static boolean isSanitizedofKind(SoyValue value, SanitizedContent.ContentKind kind) {
        return value instanceof SanitizedContent && ((SanitizedContent)value).getContentKind() == kind;
    }
}

