/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateParam;

public abstract class Environment {
    Environment() {
    }

    static Environment create(TemplateNode template, SoyRecord data, SoyRecord ijData) {
        return new Impl(template, data, ijData);
    }

    public static Environment prerenderingEnvironment() {
        return new EmptyImpl();
    }

    abstract void bind(VarDefn var1, SoyValueProvider var2);

    abstract void bindIsLast(LoopVar var1, boolean var2);

    abstract void bindCurrentIndex(LoopVar var1, int var2);

    abstract SoyValue getVar(VarDefn var1);

    abstract SoyValueProvider getVarProvider(VarDefn var1);

    abstract boolean isLast(LoopVar var1);

    abstract int getIndex(LoopVar var1);

    private static final class EmptyImpl
    extends Environment {
        private EmptyImpl() {
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void bindIsLast(LoopVar loopVar, boolean isLast) {
            throw new UnsupportedOperationException();
        }

        @Override
        void bindCurrentIndex(LoopVar loopVar, int lastIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        SoyValue getVar(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        boolean isLast(LoopVar loopVar) {
            return UndefinedData.INSTANCE.booleanValue();
        }

        @Override
        int getIndex(LoopVar loopVar) {
            return UndefinedData.INSTANCE.integerValue();
        }
    }

    private static final class Impl
    extends Environment {
        final SoyValueProvider[] localVariableTable;
        final SoyRecord data;

        Impl(TemplateNode template, SoyRecord data, SoyRecord ijData) {
            this.localVariableTable = new SoyValueProvider[template.getMaxLocalVariableTableSize()];
            this.data = data;
            for (TemplateParam param : template.getAllParams()) {
                SoyValueProvider provider = (param.isInjected() ? ijData : data).getFieldProvider(param.name());
                if (provider == null) {
                    provider = param.isRequired() ? UndefinedData.INSTANCE : NullData.INSTANCE;
                }
                this.localVariableTable[param.localVariableIndex()] = provider;
            }
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            this.localVariableTable[var.localVariableIndex()] = value;
        }

        @Override
        void bindIsLast(LoopVar loopVar, boolean isLast) {
            this.localVariableTable[loopVar.isLastIteratorIndex()] = BooleanData.forValue(isLast);
        }

        @Override
        void bindCurrentIndex(LoopVar loopVar, int lastIndex) {
            this.localVariableTable[loopVar.currentLoopIndexIndex()] = IntegerData.forValue(lastIndex);
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            if (var.kind() == VarDefn.Kind.UNDECLARED) {
                SoyValueProvider provider = this.data.getFieldProvider(var.name());
                return provider != null ? provider : (SoyValueProvider)Preconditions.checkNotNull((Object)UndefinedData.INSTANCE);
            }
            return this.localVariableTable[var.localVariableIndex()];
        }

        @Override
        SoyValue getVar(VarDefn var) {
            if (var.kind() == VarDefn.Kind.UNDECLARED) {
                SoyValue value = this.data.getField(var.name());
                return value != null ? value : (SoyValue)Preconditions.checkNotNull((Object)UndefinedData.INSTANCE);
            }
            return this.localVariableTable[var.localVariableIndex()].resolve();
        }

        @Override
        boolean isLast(LoopVar loopVar) {
            return this.localVariableTable[loopVar.isLastIteratorIndex()].resolve().booleanValue();
        }

        @Override
        int getIndex(LoopVar loopVar) {
            return this.localVariableTable[loopVar.currentLoopIndexIndex()].resolve().integerValue();
        }
    }
}

