/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

final class CheckTemplateParamsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind UNDECLARED_DATA_KEY = SoyErrorKind.of("Unknown data key ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNUSED_PARAM = SoyErrorKind.of("Param ''{0}'' unused in template body.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final TemplateRegistry templateRegistry;

    CheckTemplateParamsVisitor(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (!node.couldHaveSyntaxVersionAtLeast(SyntaxVersion.V2_0)) {
            return;
        }
        ArrayListMultimap dataKeys = ArrayListMultimap.create();
        for (VarRefNode varRefNode : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (!varRefNode.isPossibleParam().booleanValue()) continue;
            dataKeys.put((Object)varRefNode.getName(), (Object)varRefNode.getSourceLocation());
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        HashSet<String> allParamNames = new HashSet<String>();
        ArrayList<String> unusedParams = new ArrayList<String>();
        for (TemplateParam param : node.getAllParams()) {
            allParamNames.add(param.name());
            if (dataKeys.containsKey((Object)param.name())) {
                dataKeys.removeAll((Object)param.name());
                continue;
            }
            if (ipi.paramKeyToCalleesMultimap.containsKey((Object)param.name()) || ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) continue;
            unusedParams.add(param.name());
        }
        for (Map.Entry undeclared : dataKeys.entries()) {
            String extraErrorMessage = SoyErrors.getDidYouMeanMessage(allParamNames, (String)undeclared.getKey());
            this.errorReporter.report((SourceLocation)undeclared.getValue(), UNDECLARED_DATA_KEY, undeclared.getKey(), extraErrorMessage);
        }
        if (node instanceof TemplateBasicNode) {
            for (String unusedParam : unusedParams) {
                this.errorReporter.report(node.getSourceLocation(), UNUSED_PARAM, unusedParam);
            }
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

