/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.LegacyObjectMapLiteralNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.NullSafeAccumulator;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.internal.V1JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.proto.ProtoUtils;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranslateExprNodeVisitor
extends AbstractReturningExprNodeVisitor<CodeChunk.WithValue> {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final ImmutableSet<String> TRUST_PRECEDENCE_PLUGINS = ImmutableSet.of((Object)"$$debugSoyTemplateInfo");
    private static final SoyErrorKind CONSTANT_USED_AS_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Keys in map literals cannot be constants (found constant ''{0}'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPR_IN_MAP_LITERAL_REQUIRES_QUOTE_KEYS_IF_JS = SoyErrorKind.of("Expression key ''{0}'' in map literal must be wrapped in quoteKeysIfJs().", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MAP_LITERAL_WITH_NON_ID_KEY_REQUIRES_QUOTE_KEYS_IF_JS = SoyErrorKind.of("Map literal with non-identifier key {0} must be wrapped in quoteKeysIfJs().", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNION_ACCESSOR_MISMATCH = SoyErrorKind.of("Cannot access field ''{0}'' of type ''{1}'', because the different union member types have different access methods.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyJsSrcOptions jsSrcOptions;
    private final SoyToJsVariableMappings variableMappings;
    private final ErrorReporter errorReporter;
    private final CodeChunk.Generator codeGenerator;

    public TranslateExprNodeVisitor(SoyJsSrcOptions jsSrcOptions, TranslationContext translationContext, ErrorReporter errorReporter) {
        this.jsSrcOptions = jsSrcOptions;
        this.errorReporter = errorReporter;
        this.variableMappings = translationContext.soyToJsVariableMappings();
        this.codeGenerator = translationContext.codeGenerator();
    }

    static CodeChunk.WithValue genCodeForParamAccess(String paramName, boolean isInjected) {
        return isInjected ? JsRuntime.OPT_IJ_DATA.dotAccess(paramName) : JsRuntime.OPT_DATA.dotAccess(paramName);
    }

    @Override
    protected CodeChunk.WithValue visitExprRootNode(ExprRootNode node) {
        return (CodeChunk.WithValue)this.visit(node.getRoot());
    }

    @Override
    protected CodeChunk.WithValue visitBooleanNode(BooleanNode node) {
        return node.getValue() ? CodeChunk.LITERAL_TRUE : CodeChunk.LITERAL_FALSE;
    }

    @Override
    protected CodeChunk.WithValue visitFloatNode(FloatNode node) {
        return CodeChunk.number(node.getValue());
    }

    @Override
    protected CodeChunk.WithValue visitIntegerNode(IntegerNode node) {
        return CodeChunk.number(node.getValue());
    }

    @Override
    protected CodeChunk.WithValue visitNullNode(NullNode node) {
        return CodeChunk.LITERAL_NULL;
    }

    @Override
    protected CodeChunk.WithValue visitStringNode(StringNode node) {
        return CodeChunk.stringLiteral(node.getValue());
    }

    @Override
    protected CodeChunk.WithValue visitListLiteralNode(ListLiteralNode node) {
        return CodeChunk.arrayLiteral(this.visitChildren(node));
    }

    @Override
    protected CodeChunk.WithValue visitLegacyObjectMapLiteralNode(LegacyObjectMapLiteralNode node) {
        return this.visitLegacyObjectMapLiteralNode(node, false);
    }

    private CodeChunk.WithValue visitLegacyObjectMapLiteralNode(LegacyObjectMapLiteralNode node, boolean doQuoteKeys) {
        boolean isProbablyUsingClosureCompiler = this.jsSrcOptions.shouldProvideRequireSoyNamespaces() || this.jsSrcOptions.shouldProvideRequireJsFunctions();
        LinkedHashMap objLiteral = new LinkedHashMap();
        LinkedHashMap assignments = new LinkedHashMap();
        for (int i = 0; i < node.numChildren(); i += 2) {
            ExprNode keyNode = node.getChild(i);
            ExprNode valueNode = node.getChild(i + 1);
            if (!(keyNode instanceof StringNode) && keyNode instanceof ExprNode.PrimitiveNode) {
                this.errorReporter.report(keyNode.getSourceLocation(), CONSTANT_USED_AS_KEY_IN_MAP_LITERAL, keyNode.toSourceString());
                continue;
            }
            if (isProbablyUsingClosureCompiler && !doQuoteKeys && !(keyNode instanceof StringNode)) {
                this.errorReporter.report(keyNode.getSourceLocation(), EXPR_IN_MAP_LITERAL_REQUIRES_QUOTE_KEYS_IF_JS, keyNode.toSourceString());
                continue;
            }
            if (keyNode instanceof StringNode) {
                if (doQuoteKeys) {
                    objLiteral.put(this.visit(keyNode), this.visit(valueNode));
                    continue;
                }
                String strKey = ((StringNode)keyNode).getValue();
                if (BaseUtils.isIdentifier(strKey)) {
                    objLiteral.put(CodeChunk.id(strKey), this.visit(valueNode));
                    continue;
                }
                if (isProbablyUsingClosureCompiler) {
                    this.errorReporter.report(keyNode.getSourceLocation(), MAP_LITERAL_WITH_NON_ID_KEY_REQUIRES_QUOTE_KEYS_IF_JS, keyNode.toSourceString());
                    continue;
                }
                objLiteral.put(this.visit(keyNode), this.visit(valueNode));
                continue;
            }
            CodeChunk.WithValue rawKey = (CodeChunk.WithValue)this.visit(keyNode);
            assignments.put(JsRuntime.SOY_CHECK_MAP_KEY.call(rawKey), this.visit(valueNode));
        }
        ImmutableList keys = ImmutableList.copyOf(objLiteral.keySet());
        ImmutableList values = ImmutableList.copyOf(objLiteral.values());
        CodeChunk.WithValue map = CodeChunk.mapLiteral((Iterable<? extends CodeChunk.WithValue>)keys, (Iterable<? extends CodeChunk.WithValue>)values);
        if (assignments.isEmpty()) {
            return map;
        }
        CodeChunk.WithValue mapVar = this.codeGenerator.declarationBuilder().setRhs(map).build().ref();
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        for (Map.Entry entry : assignments.entrySet()) {
            initialStatements.add((Object)mapVar.bracketAccess((CodeChunk.WithValue)entry.getKey()).assign((CodeChunk.WithValue)entry.getValue()));
        }
        return mapVar.withInitialStatements((Iterable<? extends CodeChunk>)initialStatements.build());
    }

    @Override
    protected CodeChunk.WithValue visitMapLiteralNode(MapLiteralNode node) {
        CodeChunk.WithValue map = this.codeGenerator.declarationBuilder().setRhs(CodeChunk.new_(CodeChunk.id("Map")).call(new CodeChunk.WithValue[0])).build().ref();
        ImmutableList.Builder setCalls = ImmutableList.builder();
        for (int i = 0; i < node.numChildren(); i += 2) {
            CodeChunk.WithValue key = (CodeChunk.WithValue)this.visit(node.getChild(i));
            CodeChunk.WithValue value = (CodeChunk.WithValue)this.visit(node.getChild(i + 1));
            setCalls.add((Object)map.dotAccess("set").call(key.plus(CodeChunk.LITERAL_EMPTY_STRING), value));
        }
        return map.withInitialStatements((Iterable<? extends CodeChunk>)setCalls.build());
    }

    @Override
    protected CodeChunk.WithValue visitVarRefNode(VarRefNode node) {
        if (node.isDollarSignIjParameter()) {
            if (node.getName().equals("csp_nonce")) {
                return JsRuntime.OPT_IJ_DATA.and(JsRuntime.OPT_IJ_DATA.dotAccess(node.getName()), this.codeGenerator);
            }
            return JsRuntime.OPT_IJ_DATA.dotAccess(node.getName());
        }
        CodeChunk.WithValue translation = this.variableMappings.maybeGet(node.getName());
        if (translation != null) {
            return translation;
        }
        return TranslateExprNodeVisitor.genCodeForParamAccess(node.getName(), node.getDefnDecl().isInjected());
    }

    @Override
    protected CodeChunk.WithValue visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node).result(this.codeGenerator);
    }

    private NullSafeAccumulator visitNullSafeNode(ExprNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS_NODE: {
                FieldAccessNode fieldAccess = (FieldAccessNode)node;
                NullSafeAccumulator base = this.visitNullSafeNode(fieldAccess.getBaseExprChild());
                NullSafeAccumulator.FieldAccess access = this.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess, fieldAccess.getFieldName());
                return base.dotAccess(access, fieldAccess.isNullSafe());
            }
            case ITEM_ACCESS_NODE: {
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                NullSafeAccumulator base = this.visitNullSafeNode(itemAccess.getBaseExprChild());
                CodeChunk.WithValue key = (CodeChunk.WithValue)this.visit(itemAccess.getKeyExprChild());
                SoyType baseType = itemAccess.getBaseExprChild().getType();
                SoyType.Kind baseKind = baseType.getKind();
                boolean shouldUseGetter = baseKind == SoyType.Kind.MAP || baseKind == SoyType.Kind.UNION && ((UnionType)baseType).removeNullability().getKind() == SoyType.Kind.MAP;
                return shouldUseGetter ? base.dotAccess(NullSafeAccumulator.FieldAccess.call("get", key.plus(CodeChunk.WithValue.LITERAL_EMPTY_STRING)), itemAccess.isNullSafe()) : base.bracketAccess(key, itemAccess.isNullSafe());
            }
        }
        return new NullSafeAccumulator((CodeChunk.WithValue)this.visit(node));
    }

    private NullSafeAccumulator.FieldAccess genCodeForFieldAccess(SoyType baseType, FieldAccessNode fieldAccessNode, String fieldName) {
        Preconditions.checkNotNull((Object)baseType);
        if (baseType.getKind() == SoyType.Kind.UNION) {
            UnionType unionType = (UnionType)baseType;
            NullSafeAccumulator.FieldAccess fieldAccess = null;
            for (SoyType memberType : unionType.getMembers()) {
                if (memberType.getKind() == SoyType.Kind.NULL) continue;
                NullSafeAccumulator.FieldAccess fieldAccessForType = this.genCodeForFieldAccess(memberType, fieldAccessNode, fieldName);
                if (fieldAccess == null) {
                    fieldAccess = fieldAccessForType;
                    continue;
                }
                if (fieldAccess.equals(fieldAccessForType)) continue;
                this.errorReporter.report(fieldAccessNode.getSourceLocation(), UNION_ACCESSOR_MISMATCH, fieldName, baseType);
            }
            return fieldAccess;
        }
        if (baseType.getKind() == SoyType.Kind.PROTO) {
            return TranslateExprNodeVisitor.genCodeForProtoAccess((SoyProtoType)baseType, fieldName);
        }
        return NullSafeAccumulator.FieldAccess.id(fieldName);
    }

    private static NullSafeAccumulator.FieldAccess genCodeForProtoAccess(SoyProtoType type, String fieldName) {
        Descriptors.FieldDescriptor desc = type.getFieldDescriptor(fieldName);
        boolean isSanitizedContent = ProtoUtils.isSanitizedContentField(desc);
        Preconditions.checkNotNull((Object)desc, (String)"Error in proto %s, field not found: %s", (Object)type.getDescriptor().getFullName(), (Object)fieldName);
        if (desc.isExtension()) {
            return isSanitizedContent ? NullSafeAccumulator.FieldAccess.callAndUnpack().getter("getExtension").arg(JsRuntime.extensionField(desc)).unpackFunctionName(JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType())).isRepeated(desc.isRepeated() && !desc.isMapField()).build() : NullSafeAccumulator.FieldAccess.call("getExtension", JsRuntime.extensionField(desc));
        }
        String getter = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        return isSanitizedContent ? NullSafeAccumulator.FieldAccess.callAndUnpack().getter(getter).unpackFunctionName(JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType())).isRepeated(desc.isRepeated() && !desc.isMapField()).build() : NullSafeAccumulator.FieldAccess.call(getter);
    }

    @Override
    protected CodeChunk.WithValue visitGlobalNode(GlobalNode node) {
        if (node.isResolved()) {
            return (CodeChunk.WithValue)this.visit(node.getValue());
        }
        return CodeChunk.dottedIdNoRequire(node.getName());
    }

    @Override
    protected CodeChunk.WithValue visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List operands = this.visitChildren(node);
        CodeChunk.WithValue consequent = (CodeChunk.WithValue)operands.get(0);
        CodeChunk.WithValue alternate = (CodeChunk.WithValue)operands.get(1);
        if (!consequent.isCheap()) {
            consequent = this.codeGenerator.declarationBuilder().setRhs(consequent).build().ref();
        }
        return CodeChunk.ifExpression(consequent.doubleNotEquals(CodeChunk.LITERAL_NULL), consequent).else_(alternate).build(this.codeGenerator);
    }

    @Override
    protected CodeChunk.WithValue visitAndOpNode(OperatorNodes.AndOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        return ((CodeChunk.WithValue)this.visit(node.getChild(0))).and((CodeChunk.WithValue)this.visit(node.getChild(1)), this.codeGenerator);
    }

    @Override
    protected CodeChunk.WithValue visitOrOpNode(OperatorNodes.OrOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        return ((CodeChunk.WithValue)this.visit(node.getChild(0))).or((CodeChunk.WithValue)this.visit(node.getChild(1)), this.codeGenerator);
    }

    @Override
    protected CodeChunk.WithValue visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 3 ? 1 : 0) != 0);
        return this.codeGenerator.conditionalExpression((CodeChunk.WithValue)this.visit(node.getChild(0)), (CodeChunk.WithValue)this.visit(node.getChild(1)), (CodeChunk.WithValue)this.visit(node.getChild(2)));
    }

    @Override
    protected CodeChunk.WithValue visitOperatorNode(ExprNode.OperatorNode node) {
        return CodeChunk.operation(node.getOperator(), this.visitChildren(node));
    }

    @Override
    protected CodeChunk.WithValue visitProtoInitNode(ProtoInitNode node) {
        SoyProtoType type = (SoyProtoType)node.getType();
        CodeChunk.WithValue proto = CodeChunk.new_(JsRuntime.protoConstructor(type)).call(new CodeChunk.WithValue[0]);
        if (node.numChildren() == 0) {
            return proto;
        }
        CodeChunk.WithValue protoVar = this.codeGenerator.declarationBuilder().setRhs(proto).build().ref();
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        for (int i = 0; i < node.numChildren(); ++i) {
            String fieldName = node.getParamName(i);
            Descriptors.FieldDescriptor fieldDesc = type.getFieldDescriptor(fieldName);
            CodeChunk.WithValue fieldValue = (CodeChunk.WithValue)this.visit(node.getChild(i));
            if (ProtoUtils.isSanitizedContentField(fieldDesc)) {
                CodeChunk.WithValue sanitizedContentPackFn = JsRuntime.sanitizedContentToProtoConverterFunction(fieldDesc.getMessageType());
                CodeChunk.WithValue withValue = fieldValue = fieldDesc.isRepeated() ? JsRuntime.GOOG_ARRAY_MAP.call(fieldValue, sanitizedContentPackFn) : sanitizedContentPackFn.call(fieldValue);
            }
            if (fieldDesc.isExtension()) {
                CodeChunk.WithValue extInfo = JsRuntime.extensionField(fieldDesc);
                initialStatements.add((Object)protoVar.dotAccess("setExtension").call(extInfo, fieldValue));
                continue;
            }
            if (fieldDesc.isMapField()) {
                String getFn = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                CodeChunk.WithValue protoMap = protoVar.dotAccess(getFn).call(new CodeChunk.WithValue[0]);
                CodeChunk.WithValue protoMapVar = this.codeGenerator.declarationBuilder().setRhs(protoMap).build().ref();
                initialStatements.add((Object)JsRuntime.SOY_MAP_POPULATE.call(protoMapVar, fieldValue));
                continue;
            }
            String setFn = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
            initialStatements.add((Object)protoVar.dotAccess(setFn).call(fieldValue));
        }
        return protoVar.withInitialStatements((Iterable<? extends CodeChunk>)initialStatements.build());
    }

    @Override
    protected CodeChunk.WithValue visitFunctionNode(FunctionNode node) {
        SoyFunction soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            switch ((BuiltinFunction)soyFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case QUOTE_KEYS_IF_JS: {
                    return this.visitLegacyObjectMapLiteralNode((LegacyObjectMapLiteralNode)node.getChild(0), true);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case V1_EXPRESSION: {
                    return this.visitV1ExpressionFunction(node);
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof LoggingFunction) {
            return CodeChunk.stringLiteral(((LoggingFunction)soyFunction).getPlaceholder());
        }
        if (!(soyFunction instanceof SoyJsSrcFunction)) {
            soyFunction = TranslateExprNodeVisitor.getUnknownFunction(node.getFunctionName(), node.numChildren());
        }
        List args = this.visitChildren(node);
        ArrayList<JsExpr> functionInputs = new ArrayList<JsExpr>(args.size());
        ArrayList initialStatements = new ArrayList();
        CodeChunk.RequiresCollector.IntoImmutableSet collector = new CodeChunk.RequiresCollector.IntoImmutableSet();
        for (CodeChunk.WithValue arg : args) {
            arg.collectRequires(collector);
            functionInputs.add(arg.singleExprOrName());
            Iterables.addAll(initialStatements, arg.initialStatements());
        }
        SoyJsSrcFunction soyJsSrcFunction = (SoyJsSrcFunction)soyFunction;
        if (soyJsSrcFunction instanceof SoyLibraryAssistedJsSrcFunction) {
            for (String name : ((SoyLibraryAssistedJsSrcFunction)soyJsSrcFunction).getRequiredJsLibNames()) {
                collector.add(GoogRequire.create(name));
            }
        }
        JsExpr outputExpr = soyJsSrcFunction.computeForJsSrc(functionInputs);
        CodeChunk.WithValue functionOutput = TRUST_PRECEDENCE_PLUGINS.contains((Object)soyJsSrcFunction.getName()) ? CodeChunk.fromExpr(outputExpr, collector.get()) : CodeChunk.dontTrustPrecedenceOf(outputExpr, collector.get());
        return functionOutput.withInitialStatements(initialStatements);
    }

    private CodeChunk.WithValue visitCheckNotNullFunction(FunctionNode node) {
        return JsRuntime.SOY_CHECK_NOT_NULL.call((CodeChunk.WithValue)this.visit(node.getChild(0)));
    }

    private CodeChunk.WithValue visitIsFirstFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isFirst");
    }

    private CodeChunk.WithValue visitIsLastFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isLast");
    }

    private CodeChunk.WithValue visitIndexFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__index");
    }

    private CodeChunk.WithValue visitCssFunction(FunctionNode node) {
        return JsRuntime.GOOG_GET_CSS_NAME.call(this.visitChildren(node));
    }

    private CodeChunk.WithValue visitXidFunction(FunctionNode node) {
        return JsRuntime.XID.call(this.visitChildren(node));
    }

    private CodeChunk.WithValue visitV1ExpressionFunction(FunctionNode node) {
        StringNode expr = (StringNode)node.getChild(0);
        JsExpr jsExpr = V1JsExprTranslator.translateToJsExpr(expr.getValue(), expr.getSourceLocation(), this.variableMappings, this.errorReporter);
        return CodeChunk.fromExpr(jsExpr, (Iterable<GoogRequire>)ImmutableList.of());
    }

    private static SoyJsSrcFunction getUnknownFunction(final String name, final int argSize) {
        return new SoyJsSrcFunction(){

            @Override
            public JsExpr computeForJsSrc(List<JsExpr> args) {
                ArrayList<String> argStrings = new ArrayList<String>();
                for (JsExpr arg : args) {
                    argStrings.add(arg.getText());
                }
                return new JsExpr(name + "(" + COMMA_JOINER.join(argStrings) + ")", Integer.MAX_VALUE);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return ImmutableSet.of((Object)argSize);
            }
        };
    }

    public static final class TranslateExprNodeVisitorFactory {
        private final SoyJsSrcOptions jsSrcOptions;

        public TranslateExprNodeVisitorFactory(SoyJsSrcOptions jsSrcOptions) {
            this.jsSrcOptions = jsSrcOptions;
        }

        TranslateExprNodeVisitor create(TranslationContext translationContext, ErrorReporter errorReporter) {
            return new TranslateExprNodeVisitor(this.jsSrcOptions, translationContext, errorReporter);
        }
    }
}

