/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Call;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_CallAndUnpack;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Id;
import com.google.template.soy.jssrc.internal.JsRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class NullSafeAccumulator {
    private final CodeChunk.WithValue base;
    private final List<ChainAccess> chain;
    @Nullable
    private CodeChunk.WithValue unpackFunction;
    private boolean isRepeated = false;

    NullSafeAccumulator(CodeChunk.WithValue base) {
        this.base = base;
        this.chain = new ArrayList<ChainAccess>();
    }

    NullSafeAccumulator dotAccess(FieldAccess arg, boolean nullSafe) {
        if (arg instanceof CallAndUnpack) {
            Preconditions.checkState((this.unpackFunction == null ? 1 : 0) != 0, (String)"this chain will already unpack with", (Object)this.unpackFunction);
            CallAndUnpack callAndUnpack = (CallAndUnpack)arg;
            this.unpackFunction = callAndUnpack.unpackFunctionName();
            this.isRepeated = callAndUnpack.isRepeated();
        }
        this.chain.add(arg.toChainAccess(nullSafe));
        return this;
    }

    NullSafeAccumulator bracketAccess(CodeChunk.WithValue arg, boolean nullSafe) {
        this.chain.add(new Bracket(arg, nullSafe));
        this.isRepeated = false;
        return this;
    }

    CodeChunk.WithValue result(CodeChunk.Generator codeGenerator) {
        CodeChunk.WithValue accessChain = NullSafeAccumulator.buildAccessChain(this.base, codeGenerator, this.chain.iterator());
        if (this.unpackFunction == null) {
            return accessChain;
        }
        if (!this.isRepeated) {
            return this.unpackFunction.call(accessChain);
        }
        return JsRuntime.GOOG_ARRAY_MAP.call(accessChain, this.unpackFunction);
    }

    private static CodeChunk.WithValue buildAccessChain(CodeChunk.WithValue base, CodeChunk.Generator generator, Iterator<ChainAccess> chain) {
        if (!chain.hasNext()) {
            return base;
        }
        ChainAccess link = chain.next();
        if (link.nullSafe) {
            if (!base.isCheap()) {
                base = generator.declarationBuilder().setRhs(base).build().ref();
            }
            return CodeChunk.ifExpression(base.doubleEqualsNull(), CodeChunk.LITERAL_NULL).else_(NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain)).build(generator);
        }
        return NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain);
    }

    static abstract class CallAndUnpack
    extends FieldAccess {
        CallAndUnpack() {
        }

        abstract String getter();

        @Nullable
        abstract CodeChunk.WithValue arg();

        abstract CodeChunk.WithValue unpackFunctionName();

        abstract boolean isRepeated();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.arg(), nullSafe);
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder getter(String var1);

            abstract Builder arg(CodeChunk.WithValue var1);

            abstract Builder unpackFunctionName(CodeChunk.WithValue var1);

            abstract Builder isRepeated(boolean var1);

            abstract CallAndUnpack build();
        }
    }

    static abstract class Call
    extends FieldAccess {
        Call() {
        }

        abstract String getter();

        @Nullable
        abstract CodeChunk.WithValue arg();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.arg(), nullSafe);
        }
    }

    static abstract class Id
    extends FieldAccess {
        Id() {
        }

        abstract String fieldName();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new Dot(this.fieldName(), nullSafe);
        }
    }

    static abstract class FieldAccess {
        FieldAccess() {
        }

        @ForOverride
        abstract ChainAccess toChainAccess(boolean var1);

        static FieldAccess id(String fieldName) {
            return new AutoValue_NullSafeAccumulator_Id(fieldName);
        }

        static FieldAccess call(String getter, CodeChunk.WithValue arg) {
            return new AutoValue_NullSafeAccumulator_Call(getter, arg);
        }

        static FieldAccess call(String getter) {
            return new AutoValue_NullSafeAccumulator_Call(getter, null);
        }

        static CallAndUnpack.Builder callAndUnpack() {
            return new AutoValue_NullSafeAccumulator_CallAndUnpack.Builder();
        }
    }

    private static final class DotCall
    extends ChainAccess {
        final String getter;
        @Nullable
        final CodeChunk.WithValue arg;

        DotCall(String getter, @Nullable CodeChunk.WithValue arg, boolean nullSafe) {
            super(nullSafe);
            this.getter = getter;
            this.arg = arg;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return this.arg == null ? prevTip.dotAccess(this.getter).call(new CodeChunk.WithValue[0]) : prevTip.dotAccess(this.getter).call(this.arg);
        }
    }

    private static final class Dot
    extends ChainAccess {
        final String id;

        Dot(String id, boolean nullSafe) {
            super(nullSafe);
            this.id = id;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return prevTip.dotAccess(this.id);
        }
    }

    private static final class Bracket
    extends ChainAccess {
        final CodeChunk.WithValue value;

        Bracket(CodeChunk.WithValue value, boolean nullSafe) {
            super(nullSafe);
            this.value = value;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return prevTip.bracketAccess(this.value);
        }
    }

    private static abstract class ChainAccess {
        final boolean nullSafe;

        abstract CodeChunk.WithValue extend(CodeChunk.WithValue var1);

        ChainAccess(boolean nullSafe) {
            this.nullSafe = nullSafe;
        }
    }
}

