/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class Operation
extends CodeChunk.WithValue {
    Operation() {
    }

    abstract int precedence();

    abstract Operator.Associativity associativity();

    @Override
    public final JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), this.precedence());
    }

    final void formatOperand(CodeChunk.WithValue operand, OperandPosition operandPosition, FormattingContext ctx) {
        boolean protect = this.shouldProtect(operand, operandPosition);
        if (protect) {
            ctx.append('(');
        }
        operand.doFormatOutputExpr(ctx);
        if (protect) {
            ctx.append(')');
        }
    }

    private boolean shouldProtect(CodeChunk.WithValue operand, OperandPosition operandPosition) {
        if (operand instanceof Operation) {
            Operation operation = (Operation)operand;
            return operation.precedence() < this.precedence() || operation.precedence() == this.precedence() && operandPosition.shouldParenthesize(operation.associativity());
        }
        if (operand instanceof Leaf) {
            JsExpr expr = ((Leaf)operand).value();
            return expr.getPrecedence() < this.precedence();
        }
        return false;
    }
}

