/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_MapLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
abstract class MapLiteral
extends CodeChunk.WithValue {
    MapLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> keys();

    abstract ImmutableList<? extends CodeChunk.WithValue> values();

    static MapLiteral create(ImmutableList<? extends CodeChunk.WithValue> keys, ImmutableList<? extends CodeChunk.WithValue> values) {
        Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Mismatch between keys and values.");
        ImmutableSet.Builder initialStatements = ImmutableSet.builder();
        for (CodeChunk.WithValue key : keys) {
            initialStatements.addAll(key.initialStatements());
        }
        for (CodeChunk.WithValue value : values) {
            initialStatements.addAll(value.initialStatements());
        }
        return new AutoValue_MapLiteral((ImmutableSet<CodeChunk>)initialStatements.build(), keys, values);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('{');
        for (int i = 0; i < this.keys().size(); ++i) {
            if (i > 0) {
                ctx.append(", ");
            }
            ctx.appendOutputExpression((CodeChunk.WithValue)this.keys().get(i)).append(": ").appendOutputExpression((CodeChunk.WithValue)this.values().get(i));
        }
        ctx.append('}');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk.WithValue key : this.keys()) {
            ctx.appendInitialStatements(key);
        }
        for (CodeChunk.WithValue value : this.values()) {
            ctx.appendInitialStatements(value);
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue key : this.keys()) {
            key.collectRequires(collector);
        }
        for (CodeChunk.WithValue value : this.values()) {
            value.collectRequires(collector);
        }
    }
}

