/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.Message;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.AutoValue_MethodRef;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.types.proto.SoyProtoValueImpl;
import com.ibm.icu.util.ULocale;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public abstract class MethodRef {
    public static final MethodRef ADVISING_STRING_BUILDER_GET_AND_CLEAR = MethodRef.create(LoggingAdvisingAppendable.BufferingAppendable.class, "getAndClearBuffer", new Class[0]).asNonNullable();
    public static final MethodRef ARRAY_LIST_ADD = MethodRef.create(ArrayList.class, "add", Object.class);
    public static final MethodRef BOOLEAN_DATA_FOR_VALUE = MethodRef.create(BooleanData.class, "forValue", Boolean.TYPE).asNonNullable();
    public static final MethodRef BOOLEAN_VALUE = MethodRef.create(Boolean.class, "booleanValue", new Class[0]).asCheap();
    public static final MethodRef BOOLEAN_TO_STRING = MethodRef.create(Boolean.class, "toString", Boolean.TYPE).asCheap().asNonNullable();
    public static final MethodRef COMPILED_TEMPLATE_RENDER = MethodRef.create(CompiledTemplate.class, "render", LoggingAdvisingAppendable.class, RenderContext.class).asNonNullable();
    public static final MethodRef DICT_IMPL_FOR_PROVIDER_MAP = MethodRef.create(DictImpl.class, "forProviderMap", Map.class).asNonNullable();
    public static final MethodRef MAP_IMPL_FOR_PROVIDER_MAP = MethodRef.create(SoyMapImpl.class, "forProviderMap", Map.class).asNonNullable();
    public static final MethodRef DOUBLE_TO_STRING = MethodRef.create(Double.class, "toString", Double.TYPE).asNonNullable();
    public static final MethodRef EQUALS = MethodRef.create(Object.class, "equals", Object.class);
    public static final MethodRef STRING_COMPARE_TO = MethodRef.create(String.class, "compareTo", String.class);
    public static final MethodRef FLOAT_DATA_FOR_VALUE = MethodRef.create(FloatData.class, "forValue", Double.TYPE).asNonNullable();
    public static final ImmutableList<MethodRef> IMMUTABLE_LIST_OF;
    public static final MethodRef IMMUTABLE_LIST_OF_ARRAY;
    public static final MethodRef INTEGER_DATA_FOR_VALUE;
    public static final MethodRef INTS_CHECKED_CAST;
    public static final MethodRef LINKED_HASH_MAP_CLEAR;
    public static final MethodRef LINKED_HASH_MAP_PUT;
    public static final MethodRef LIST_GET;
    public static final MethodRef LIST_SIZE;
    public static final MethodRef MAP_SIZE;
    public static final MethodRef MAP_ENTRY_SET;
    public static final MethodRef GET_ITERATOR;
    public static final MethodRef ITERATOR_NEXT;
    public static final MethodRef ITERATOR_HAS_NEXT;
    public static final MethodRef MAP_GET_KEY;
    public static final MethodRef MAP_GET_VALUE;
    public static final MethodRef LIST_IMPL_FOR_PROVIDER_LIST;
    public static final MethodRef LONG_PARSE_LONG;
    public static final MethodRef UNSIGNED_LONGS_PARSE_UNSIGNED_LONG;
    public static final MethodRef UNSIGNED_LONGS_TO_STRING;
    public static final MethodRef UNSIGNED_INTS_SATURATED_CAST;
    public static final MethodRef UNSIGNED_INTS_TO_LONG;
    public static final MethodRef LONG_TO_STRING;
    public static final MethodRef NUMBER_DOUBLE_VALUE;
    public static final MethodRef NUMBER_LONG_VALUE;
    public static final MethodRef NUMBER_INT_VALUE;
    public static final MethodRef OBJECT_TO_STRING;
    public static final MethodRef ORDAIN_AS_SAFE;
    public static final MethodRef PARAM_STORE_SET_FIELD;
    public static final MethodRef PRINT_STREAM_PRINTLN;
    public static final MethodRef SOY_PROTO_VALUE_IMPL_CREATE;
    public static final MethodRef RENDER_RESULT_DONE;
    public static final MethodRef RENDER_RESULT_IS_DONE;
    public static final MethodRef RENDER_RESULT_LIMITED;
    public static final MethodRef RUNTIME_APPLY_ESCAPERS;
    public static final MethodRef RUNTIME_RANGE_LOOP_LENGTH;
    public static final MethodRef RUNTIME_APPLY_PRINT_DIRECTIVE;
    public static final MethodRef RUNTIME_CALL_SOY_FUNCTION;
    public static final MethodRef RUNTIME_COERCE_DOUBLE_TO_BOOLEAN;
    public static final MethodRef RUNTIME_COERCE_TO_STRING;
    public static final MethodRef RUNTIME_EQUAL;
    public static final MethodRef RUNTIME_COMPARE_STRING;
    public static final MethodRef RUNTIME_GET_FIELD_PROVIDER;
    public static final MethodRef RUNTIME_GET_LIST_ITEM;
    public static final MethodRef RUNTIME_GET_LIST_STATUS;
    public static final MethodRef RUNTIME_GET_MAP_STATUS;
    public static final MethodRef RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM;
    public static final MethodRef RUNTIME_GET_MAP_ITEM;
    public static final MethodRef RUNTIME_LESS_THAN;
    public static final MethodRef RUNTIME_LESS_THAN_OR_EQUAL;
    public static final MethodRef RUNTIME_LOGGER;
    public static final MethodRef RUNTIME_MINUS;
    public static final MethodRef RUNTIME_NEGATIVE;
    public static final MethodRef RUNTIME_PLUS;
    public static final MethodRef RUNTIME_RENDER_SOY_MSG_PARTS_WITH_PLACEHOLDERS;
    public static final MethodRef RUNTIME_STRING_EQUALS_AS_NUMBER;
    public static final MethodRef RUNTIME_TIMES;
    public static final MethodRef RUNTIME_UNEXPECTED_STATE_ERROR;
    public static final MethodRef SOY_LIST_AS_JAVA_LIST;
    public static final MethodRef SOY_DICT_IMPL_AS_JAVA_MAP;
    public static final MethodRef SOY_MAP_IMPL_AS_JAVA_MAP;
    public static final MethodRef SOY_MSG_RAW_TEXT_PART_GET_RAW_TEXT;
    public static final MethodRef SOY_PROTO_VALUE_GET_PROTO_FIELD;
    public static final MethodRef SOY_PROTO_VALUE_GET_PROTO;
    public static final MethodRef SOY_VALUE_COERCE_TO_BOOLEAN;
    public static final MethodRef SOY_VALUE_BOOLEAN_VALUE;
    public static final MethodRef SOY_VALUE_FLOAT_VALUE;
    public static final MethodRef SOY_VALUE_LONG_VALUE;
    public static final MethodRef SOY_VALUE_NUMBER_VALUE;
    public static final MethodRef SOY_VALUE_STRING_VALUE;
    public static final MethodRef SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE;
    public static final MethodRef SOY_VALUE_PROVIDER_RESOLVE;
    public static final MethodRef SOY_VALUE_PROVIDER_STATUS;
    public static final MethodRef STRING_CONCAT;
    public static final MethodRef STRING_IS_EMPTY;
    public static final MethodRef STRING_VALUE_OF;
    public static final MethodRef STRING_DATA_FOR_VALUE;
    public static final MethodRef LOGGING_ADVISING_APPENDABLE_BUFFERING;
    public static final MethodRef LOG_STATEMENT_CREATE;
    public static final MethodRef CLOSEABLE_CLOSE;

    public static MethodRef create(Class<?> clazz, String methodName, Class<?> ... params) {
        java.lang.reflect.Method m;
        try {
            m = clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't find the expected method among: " + Arrays.toString(clazz.getMethods()), e);
        }
        return MethodRef.create(m);
    }

    public static MethodRef create(java.lang.reflect.Method method) {
        Class<?> clazz = method.getDeclaringClass();
        TypeInfo ownerType = TypeInfo.create(method.getDeclaringClass());
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        ImmutableList argTypes = isStatic ? ImmutableList.copyOf((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)) : ImmutableList.builder().add((Object)ownerType.type()).add((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)).build();
        return new AutoValue_MethodRef(clazz.isInterface() ? 185 : (isStatic ? 184 : 182), ownerType, Method.getMethod((java.lang.reflect.Method)method), Type.getType(method.getReturnType()), (ImmutableList<Type>)argTypes, Expression.Features.of());
    }

    public static MethodRef createInstanceMethod(TypeInfo owner, Method method) {
        return new AutoValue_MethodRef(182, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    public static MethodRef createStaticMethod(TypeInfo owner, Method method) {
        return new AutoValue_MethodRef(184, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    abstract int opcode();

    public abstract TypeInfo owner();

    public abstract Method method();

    public abstract Type returnType();

    abstract ImmutableList<Type> argTypes();

    public abstract Expression.Features features();

    public Statement invokeVoid(Expression ... args) {
        return this.invokeVoid(Arrays.asList(args));
    }

    public Statement invokeVoid(final Iterable<? extends Expression> args) {
        Preconditions.checkState((boolean)Type.VOID_TYPE.equals((Object)this.returnType()), (Object)"Method return type is not void.");
        Expression.checkTypes(this.argTypes(), args);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                MethodRef.this.doInvoke(adapter, args);
            }
        };
    }

    public Expression invoke(Expression ... args) {
        return this.invoke(Arrays.asList(args));
    }

    Expression invoke(final Iterable<? extends Expression> args) {
        Preconditions.checkState((!Type.VOID_TYPE.equals((Object)this.returnType()) ? 1 : 0) != 0, (Object)"Cannot produce an expression from a void method.");
        Expression.checkTypes(this.argTypes(), args);
        Expression.Features features = this.features();
        if (!Expression.areAllCheap(args)) {
            features = features.minus(Expression.Feature.CHEAP);
        }
        return new Expression(this.returnType(), features){

            @Override
            protected void doGen(CodeBuilder mv) {
                MethodRef.this.doInvoke(mv, args);
            }
        };
    }

    public MethodRef asCheap() {
        return this.withFeature(Expression.Feature.CHEAP);
    }

    public MethodRef asNonNullable() {
        return this.withFeature(Expression.Feature.NON_NULLABLE);
    }

    private MethodRef withFeature(Expression.Feature feature) {
        if (this.features().has(feature)) {
            return this;
        }
        return new AutoValue_MethodRef(this.opcode(), this.owner(), this.method(), this.returnType(), this.argTypes(), this.features().plus(feature));
    }

    public void invokeUnchecked(CodeBuilder cb) {
        cb.visitMethodInsn(this.opcode(), this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.opcode() == 185);
    }

    private void doInvoke(CodeBuilder mv, Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            expression.gen(mv);
        }
        this.invokeUnchecked(mv);
    }

    static {
        Object[] immutableListOfMethods = new MethodRef[12];
        MethodRef immutableListOfArray = null;
        for (java.lang.reflect.Method m : ImmutableList.class.getMethods()) {
            if (!m.getName().equals("of")) continue;
            Class<?>[] params = m.getParameterTypes();
            MethodRef ref = MethodRef.create(m).asNonNullable();
            if (params.length > 0 && params[params.length - 1].isArray()) {
                immutableListOfArray = ref;
                continue;
            }
            int arity = params.length;
            if (arity == 0) {
                ref = ref.asCheap();
            }
            immutableListOfMethods[arity] = ref;
        }
        IMMUTABLE_LIST_OF_ARRAY = immutableListOfArray;
        IMMUTABLE_LIST_OF = ImmutableList.copyOf((Object[])immutableListOfMethods);
        INTEGER_DATA_FOR_VALUE = MethodRef.create(IntegerData.class, "forValue", Long.TYPE).asNonNullable();
        INTS_CHECKED_CAST = MethodRef.create(Ints.class, "checkedCast", Long.TYPE).asCheap();
        LINKED_HASH_MAP_CLEAR = MethodRef.create(LinkedHashMap.class, "clear", new Class[0]);
        LINKED_HASH_MAP_PUT = MethodRef.create(LinkedHashMap.class, "put", Object.class, Object.class);
        LIST_GET = MethodRef.create(List.class, "get", Integer.TYPE).asCheap();
        LIST_SIZE = MethodRef.create(List.class, "size", new Class[0]).asCheap();
        MAP_SIZE = MethodRef.create(Map.class, "size", new Class[0]).asCheap();
        MAP_ENTRY_SET = MethodRef.create(Map.class, "entrySet", new Class[0]);
        GET_ITERATOR = MethodRef.create(Iterable.class, "iterator", new Class[0]);
        ITERATOR_NEXT = MethodRef.create(Iterator.class, "next", new Class[0]);
        ITERATOR_HAS_NEXT = MethodRef.create(Iterator.class, "hasNext", new Class[0]);
        MAP_GET_KEY = MethodRef.create(Map.Entry.class, "getKey", new Class[0]);
        MAP_GET_VALUE = MethodRef.create(Map.Entry.class, "getValue", new Class[0]);
        LIST_IMPL_FOR_PROVIDER_LIST = MethodRef.create(ListImpl.class, "forProviderList", List.class);
        LONG_PARSE_LONG = MethodRef.create(Long.class, "parseLong", String.class).asCheap().asNonNullable();
        UNSIGNED_LONGS_PARSE_UNSIGNED_LONG = MethodRef.create(UnsignedLongs.class, "parseUnsignedLong", String.class).asCheap();
        UNSIGNED_LONGS_TO_STRING = MethodRef.create(UnsignedLongs.class, "toString", Long.TYPE).asCheap().asNonNullable();
        UNSIGNED_INTS_SATURATED_CAST = MethodRef.create(UnsignedInts.class, "saturatedCast", Long.TYPE).asCheap();
        UNSIGNED_INTS_TO_LONG = MethodRef.create(UnsignedInts.class, "toLong", Integer.TYPE).asCheap();
        LONG_TO_STRING = MethodRef.create(Long.class, "toString", Long.TYPE);
        NUMBER_DOUBLE_VALUE = MethodRef.create(Number.class, "doubleValue", new Class[0]).asCheap();
        NUMBER_LONG_VALUE = MethodRef.create(Number.class, "longValue", new Class[0]).asCheap();
        NUMBER_INT_VALUE = MethodRef.create(Number.class, "intValue", new Class[0]).asCheap();
        OBJECT_TO_STRING = MethodRef.create(Object.class, "toString", new Class[0]);
        ORDAIN_AS_SAFE = MethodRef.create(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class);
        PARAM_STORE_SET_FIELD = MethodRef.create(ParamStore.class, "setField", String.class, SoyValueProvider.class);
        PRINT_STREAM_PRINTLN = MethodRef.create(PrintStream.class, "println", new Class[0]);
        SOY_PROTO_VALUE_IMPL_CREATE = MethodRef.create(SoyProtoValueImpl.class, "create", Message.class).asNonNullable();
        RENDER_RESULT_DONE = MethodRef.create(RenderResult.class, "done", new Class[0]).asCheap().asNonNullable();
        RENDER_RESULT_IS_DONE = MethodRef.create(RenderResult.class, "isDone", new Class[0]).asCheap();
        RENDER_RESULT_LIMITED = MethodRef.create(RenderResult.class, "limited", new Class[0]).asCheap().asNonNullable();
        RUNTIME_APPLY_ESCAPERS = MethodRef.create(JbcSrcRuntime.class, "applyEscapers", CompiledTemplate.class, ImmutableList.class);
        RUNTIME_RANGE_LOOP_LENGTH = MethodRef.create(JbcSrcRuntime.class, "rangeLoopLength", Integer.TYPE, Integer.TYPE, Integer.TYPE).asCheap();
        RUNTIME_APPLY_PRINT_DIRECTIVE = MethodRef.create(JbcSrcRuntime.class, "applyPrintDirective", SoyJavaPrintDirective.class, SoyValue.class, List.class);
        RUNTIME_CALL_SOY_FUNCTION = MethodRef.create(JbcSrcRuntime.class, "callSoyFunction", SoyJavaFunction.class, List.class);
        RUNTIME_COERCE_DOUBLE_TO_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "coerceToBoolean", Double.TYPE);
        RUNTIME_COERCE_TO_STRING = MethodRef.create(JbcSrcRuntime.class, "coerceToString", SoyValue.class).asNonNullable();
        RUNTIME_EQUAL = MethodRef.create(SharedRuntime.class, "equal", SoyValue.class, SoyValue.class);
        RUNTIME_COMPARE_STRING = MethodRef.create(SharedRuntime.class, "compareString", String.class, SoyValue.class);
        RUNTIME_GET_FIELD_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getFieldProvider", SoyRecord.class, String.class).asNonNullable();
        RUNTIME_GET_LIST_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyListItem", List.class, Long.TYPE);
        RUNTIME_GET_LIST_STATUS = MethodRef.create(JbcSrcRuntime.class, "getListStatus", List.class);
        RUNTIME_GET_MAP_STATUS = MethodRef.create(JbcSrcRuntime.class, "getMapStatus", Map.class);
        RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyLegacyObjectMapItem", SoyMap.class, SoyValue.class);
        RUNTIME_GET_MAP_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyMapItem", SoyNewMap.class, SoyValue.class);
        RUNTIME_LESS_THAN = MethodRef.create(SharedRuntime.class, "lessThan", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_LESS_THAN_OR_EQUAL = MethodRef.create(SharedRuntime.class, "lessThanOrEqual", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_LOGGER = MethodRef.create(JbcSrcRuntime.class, "logger", new Class[0]).asCheap().asNonNullable();
        RUNTIME_MINUS = MethodRef.create(SharedRuntime.class, "minus", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_NEGATIVE = MethodRef.create(SharedRuntime.class, "negative", SoyValue.class).asNonNullable();
        RUNTIME_PLUS = MethodRef.create(SharedRuntime.class, "plus", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_RENDER_SOY_MSG_PARTS_WITH_PLACEHOLDERS = MethodRef.create(JbcSrcRuntime.class, "renderSoyMsgPartsWithPlaceholders", ImmutableList.class, ULocale.class, Map.class, Appendable.class);
        RUNTIME_STRING_EQUALS_AS_NUMBER = MethodRef.create(JbcSrcRuntime.class, "stringEqualsAsNumber", String.class, Double.TYPE).asNonNullable();
        RUNTIME_TIMES = MethodRef.create(SharedRuntime.class, "times", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_UNEXPECTED_STATE_ERROR = MethodRef.create(JbcSrcRuntime.class, "unexpectedStateError", Integer.TYPE).asNonNullable();
        SOY_LIST_AS_JAVA_LIST = MethodRef.create(SoyList.class, "asJavaList", new Class[0]).asNonNullable();
        SOY_DICT_IMPL_AS_JAVA_MAP = MethodRef.create(DictImpl.class, "asJavaStringMap", new Class[0]).asNonNullable();
        SOY_MAP_IMPL_AS_JAVA_MAP = MethodRef.create(SoyNewMap.class, "asJavaStringMap", new Class[0]).asNonNullable();
        SOY_MSG_RAW_TEXT_PART_GET_RAW_TEXT = MethodRef.create(SoyMsgRawTextPart.class, "getRawText", new Class[0]).asCheap().asNonNullable();
        SOY_PROTO_VALUE_GET_PROTO_FIELD = MethodRef.create(SoyProtoValueImpl.class, "getProtoField", String.class).asCheap().asNonNullable();
        SOY_PROTO_VALUE_GET_PROTO = MethodRef.create(SoyProtoValueImpl.class, "getProto", new Class[0]).asCheap().asNonNullable();
        SOY_VALUE_COERCE_TO_BOOLEAN = MethodRef.create(SoyValue.class, "coerceToBoolean", new Class[0]).asCheap();
        SOY_VALUE_BOOLEAN_VALUE = MethodRef.create(SoyValue.class, "booleanValue", new Class[0]).asCheap();
        SOY_VALUE_FLOAT_VALUE = MethodRef.create(SoyValue.class, "floatValue", new Class[0]).asCheap();
        SOY_VALUE_LONG_VALUE = MethodRef.create(SoyValue.class, "longValue", new Class[0]).asCheap();
        SOY_VALUE_NUMBER_VALUE = MethodRef.create(SoyValue.class, "numberValue", new Class[0]).asNonNullable();
        SOY_VALUE_STRING_VALUE = MethodRef.create(SoyValue.class, "stringValue", new Class[0]).asCheap().asNonNullable();
        SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE = MethodRef.create(SoyValueProvider.class, "renderAndResolve", LoggingAdvisingAppendable.class, Boolean.TYPE).asNonNullable();
        SOY_VALUE_PROVIDER_RESOLVE = MethodRef.create(JbcSrcRuntime.class, "resolveSoyValueProvider", SoyValueProvider.class);
        SOY_VALUE_PROVIDER_STATUS = MethodRef.create(SoyValueProvider.class, "status", new Class[0]).asNonNullable();
        STRING_CONCAT = MethodRef.create(String.class, "concat", String.class).asNonNullable();
        STRING_IS_EMPTY = MethodRef.create(String.class, "isEmpty", new Class[0]);
        STRING_VALUE_OF = MethodRef.create(String.class, "valueOf", Object.class).asNonNullable();
        STRING_DATA_FOR_VALUE = MethodRef.create(StringData.class, "forValue", String.class).asCheap().asNonNullable();
        LOGGING_ADVISING_APPENDABLE_BUFFERING = MethodRef.create(LoggingAdvisingAppendable.class, "buffering", new Class[0]).asNonNullable();
        LOG_STATEMENT_CREATE = MethodRef.create(LogStatement.class, "create", Long.TYPE, Message.class, Boolean.TYPE).asNonNullable();
        CLOSEABLE_CLOSE = MethodRef.create(Closeable.class, "close", new Class[0]);
    }
}

