/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import java.io.IOException;

final class Continuations {
    private Continuations() {
    }

    static SoySauce.WriteContinuation done() {
        return FinalContinuation.INSTANCE;
    }

    static SoySauce.Continuation<String> stringContinuation(SoySauce.WriteContinuation delegate, final StringBuilder buffer, OutputAppendable appendable) {
        if (delegate.result().isDone()) {
            return new ResultContinuation<String>(buffer.toString());
        }
        return new AbstractContinuation<String>(delegate, appendable){

            @Override
            SoySauce.Continuation<String> nextContinuation(SoySauce.WriteContinuation next) {
                return Continuations.stringContinuation(next, buffer, this.appendable);
            }
        };
    }

    static SoySauce.Continuation<SanitizedContent> strictContinuation(SoySauce.WriteContinuation delegate, final StringBuilder buffer, OutputAppendable appendable, final SanitizedContent.ContentKind kind) {
        if (delegate.result().isDone()) {
            return new ResultContinuation<SanitizedContent>(UnsafeSanitizedContentOrdainer.ordainAsSafe(buffer.toString(), kind));
        }
        return new AbstractContinuation<SanitizedContent>(delegate, appendable){

            @Override
            SoySauce.Continuation<SanitizedContent> nextContinuation(SoySauce.WriteContinuation next) {
                return Continuations.strictContinuation(next, buffer, this.appendable, kind);
            }
        };
    }

    private static final class ResultContinuation<T>
    implements SoySauce.Continuation<T> {
        final T value;

        ResultContinuation(T value) {
            this.value = Preconditions.checkNotNull(value);
        }

        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public SoySauce.Continuation<T> continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }

    private static enum FinalContinuation implements SoySauce.WriteContinuation
    {
        INSTANCE;


        @Override
        public RenderResult result() {
            return RenderResult.done();
        }

        @Override
        public SoySauce.WriteContinuation continueRender() {
            throw new IllegalStateException("Rendering is already complete and cannot be continued");
        }
    }

    private static abstract class AbstractContinuation<T>
    implements SoySauce.Continuation<T> {
        final SoySauce.WriteContinuation delegate;
        final OutputAppendable appendable;

        AbstractContinuation(SoySauce.WriteContinuation delegate, OutputAppendable appendable) {
            this.delegate = delegate;
            this.appendable = appendable;
        }

        @Override
        public final RenderResult result() {
            return this.delegate.result();
        }

        @Override
        public final T get() {
            throw new IllegalStateException("Rendering is not complete");
        }

        @Override
        public final SoySauce.Continuation<T> continueRender() {
            try {
                return this.nextContinuation(this.delegate.continueRender());
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        abstract SoySauce.Continuation<T> nextContinuation(SoySauce.WriteContinuation var1);
    }
}

