/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.CompilingClassLoader;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.MemoryClassLoader;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BytecodeCompiler {
    private static final Logger logger = Logger.getLogger(BytecodeCompiler.class.getName());
    private static final SoyErrorKind UNEXPECTED_COMPILER_FAILURE = SoyErrorKind.of("Unexpected error while compiling template: ''{0}''\nSoy Stack:\n{1}\nCompiler Stack:\n{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of("Unexpected error while compiling template: ''{0}''\n{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);

    public static Optional<CompiledTemplates> compile(final TemplateRegistry registry, boolean developmentMode, ErrorReporter reporter) {
        final Stopwatch stopwatch = Stopwatch.createStarted();
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return Optional.absent();
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        if (developmentMode) {
            CompiledTemplates templates = new CompiledTemplates(compilerRegistry.getDelegateTemplateNames(), new CompilingClassLoader(compilerRegistry));
            return Optional.of((Object)templates);
        }
        List<ClassData> classes = BytecodeCompiler.compileTemplates(compilerRegistry, reporter, new CompilerListener<List<ClassData>>(){
            final List<ClassData> compiledClasses = new ArrayList<ClassData>();
            int numBytes = 0;
            int numFields = 0;
            int numDetachStates = 0;

            @Override
            public void onCompile(ClassData clazz) {
                this.numBytes += clazz.data().length;
                this.numFields += clazz.numberOfFields();
                this.numDetachStates += clazz.numberOfDetachStates();
                this.compiledClasses.add(clazz);
            }

            @Override
            public List<ClassData> getResult() {
                logger.log(Level.INFO, "Compilation took {0}\n     templates: {1}\n       classes: {2}\n         bytes: {3}\n        fields: {4}\n  detachStates: {5}", new Object[]{stopwatch.toString(), registry.getAllTemplates().size(), this.compiledClasses.size(), this.numBytes, this.numFields, this.numDetachStates});
                return this.compiledClasses;
            }
        });
        if (reporter.errorsSince(checkpoint)) {
            return Optional.absent();
        }
        CompiledTemplates templates = new CompiledTemplates(compilerRegistry.getDelegateTemplateNames(), new MemoryClassLoader(classes));
        stopwatch.reset().start();
        templates.loadAll((Iterable<String>)compilerRegistry.getTemplateNames());
        logger.log(Level.INFO, "Loaded all classes in {0}", stopwatch);
        return Optional.of((Object)templates);
    }

    public static void compileToJar(TemplateRegistry registry, ErrorReporter reporter, ByteSink sink) throws IOException {
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        try (final SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            BytecodeCompiler.compileTemplates(compilerRegistry, reporter, new CompilerListener<Void>(){

                @Override
                void onCompile(ClassData clazz) throws IOException {
                    writer.writeEntry(clazz.type().internalName() + ".class", ByteSource.wrap((byte[])clazz.data()));
                }
            });
        }
    }

    public static void writeSrcJar(TemplateRegistry registry, ImmutableMap<String, SoyFileSupplier> files, ByteSink sink) throws IOException {
        HashSet<SoyFileNode> seenFiles = new HashSet<SoyFileNode>();
        try (SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            for (TemplateNode template : registry.getAllTemplates()) {
                SoyFileNode file = template.getParent();
                if (file.getSoyFileKind() != SoyFileKind.SRC || !seenFiles.add(file)) continue;
                String namespace = file.getNamespace();
                String fileName = file.getFileName();
                writer.writeEntry(Names.javaFileName(namespace, fileName), ((SoyFileSupplier)files.get((Object)file.getFilePath())).asCharSource().asByteSource(StandardCharsets.UTF_8));
            }
        }
    }

    private static <T> T compileTemplates(CompiledTemplateRegistry registry, ErrorReporter errorReporter, CompilerListener<T> listener) {
        for (String name : registry.getTemplateNames()) {
            CompiledTemplateMetadata classInfo = registry.getTemplateInfoByTemplateName(name);
            if (classInfo.node().getParent().getSoyFileKind() != SoyFileKind.SRC) continue;
            try {
                TemplateCompiler templateCompiler = new TemplateCompiler(registry, classInfo);
                for (ClassData clazz : templateCompiler.compile()) {
                    if (Flags.DEBUG) {
                        clazz.checkClass();
                    }
                    listener.onCompile(clazz);
                }
            }
            catch (UnexpectedCompilerFailureException e) {
                errorReporter.report(e.getOriginalLocation(), UNEXPECTED_COMPILER_FAILURE, name, e.printSoyStack(), Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (Throwable t) {
                errorReporter.report(classInfo.node().getSourceLocation(), UNEXPECTED_ERROR, name, Throwables.getStackTraceAsString((Throwable)t));
            }
        }
        return listener.getResult();
    }

    private BytecodeCompiler() {
    }

    private static abstract class CompilerListener<T> {
        private CompilerListener() {
        }

        abstract void onCompile(ClassData var1) throws Exception;

        T getResult() {
            return null;
        }
    }
}

