/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.i18ndirectives.I18NDirectivesRuntime;
import com.google.template.soy.i18ndirectives.I18nUtils;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.objectweb.asm.Type;

class FormatNumDirective
implements SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective {
    private static final ImmutableMap<String, String> JS_ARGS_TO_ENUM = ImmutableMap.builder().put((Object)"'decimal'", (Object)"goog.i18n.NumberFormat.Format.DECIMAL").put((Object)"'currency'", (Object)"goog.i18n.NumberFormat.Format.CURRENCY").put((Object)"'percent'", (Object)"goog.i18n.NumberFormat.Format.PERCENT").put((Object)"'scientific'", (Object)"goog.i18n.NumberFormat.Format.SCIENTIFIC").put((Object)"'compact_short'", (Object)"goog.i18n.NumberFormat.Format.COMPACT_SHORT").put((Object)"'compact_long'", (Object)"goog.i18n.NumberFormat.Format.COMPACT_LONG").build();
    private static final ImmutableSet<Integer> VALID_ARGS_SIZES = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4);
    private static final ImmutableSet<String> REQUIRED_JS_LIBS = ImmutableSet.of((Object)"goog.i18n.NumberFormat");
    private static final String DEFAULT_FORMAT = "decimal";
    private final Provider<String> localeStringProvider;

    @Inject
    FormatNumDirective(@ApiCallScopeBindingAnnotations.LocaleString Provider<String> localeStringProvider) {
        this.localeStringProvider = localeStringProvider;
    }

    @Override
    public String getName() {
        return "|formatNum";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return VALID_ARGS_SIZES;
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        ULocale uLocale = I18nUtils.parseULocale((String)this.localeStringProvider.get());
        String formatType = args.isEmpty() ? DEFAULT_FORMAT : args.get(0).stringValue();
        String numbersKeyword = "local";
        if (args.size() > 1) {
            numbersKeyword = args.get(1).stringValue();
        }
        Integer minFractionDigits = args.size() > 2 ? Integer.valueOf((int)args.get(2).numberValue()) : null;
        Integer maxFractionDigits = args.size() > 3 ? Integer.valueOf((int)args.get(3).numberValue()) : minFractionDigits;
        double number = value.numberValue();
        return StringData.forValue(I18NDirectivesRuntime.formatNum(uLocale, number, formatType, numbersKeyword, minFractionDigits, maxFractionDigits));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String numberFormatType = FormatNumDirective.parseFormat(args);
        StringBuilder expr = new StringBuilder();
        expr.append("(new goog.i18n.NumberFormat(" + (String)JS_ARGS_TO_ENUM.get((Object)numberFormatType) + "))");
        if (args.size() > 2) {
            String minFractionDigits = args.get(2).getText();
            String maxFractionDigits = args.size() > 3 ? args.get(3).getText() : minFractionDigits;
            expr.append(".setMinimumFractionDigits(").append(minFractionDigits).append(")");
            expr.append(".setMaximumFractionDigits(").append(maxFractionDigits).append(")");
        } else if ("'compact_short'".equals(numberFormatType) || "'compact_long'".equals(numberFormatType)) {
            expr.append(".setSignificantDigits(3)");
        }
        expr.append(".format(" + value.getText() + ")");
        return new JsExpr(expr.toString(), Integer.MAX_VALUE);
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        String numberFormatType = FormatNumDirective.parseFormat(args);
        PyFunctionExprBuilder builder = new PyFunctionExprBuilder("translator_impl.format_num").addArg(value).addArg(new PyExpr(numberFormatType, Integer.MAX_VALUE));
        if (args.size() > 2) {
            String minFractionDigits = args.get(2).getText();
            String maxFractionDigits = args.size() > 3 ? args.get(3).getText() : minFractionDigits;
            builder.addArg(minFractionDigits).addArg(maxFractionDigits);
        }
        return builder.asPyStringExpr();
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return REQUIRED_JS_LIBS;
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        Expression minFractionDigits = args.size() > 2 ? MethodRef.create(Integer.class, "valueOf", Integer.TYPE).invoke(BytecodeUtils.numericConversion(args.get(2).unboxAs(Long.TYPE), Type.INT_TYPE)) : BytecodeUtils.constantNull(Type.getType(Integer.class));
        Expression maxFractionDigits = args.size() > 3 ? MethodRef.create(Integer.class, "valueOf", Integer.TYPE).invoke(BytecodeUtils.numericConversion(args.get(3).unboxAs(Long.TYPE), Type.INT_TYPE)) : minFractionDigits;
        return SoyExpression.forString(JbcSrcMethods.FORMAT_NUM.invoke(context.getULocale(), value.coerceToDouble(), !args.isEmpty() ? args.get(0).unboxAs(String.class) : BytecodeUtils.constant(DEFAULT_FORMAT), args.size() > 1 ? args.get(1).unboxAs(String.class) : BytecodeUtils.constant("local"), minFractionDigits, maxFractionDigits));
    }

    private static String parseFormat(List<? extends TargetExpr> args) {
        String numberFormatType;
        String string = numberFormatType = !args.isEmpty() ? args.get(0).getText() : "'decimal'";
        if (!JS_ARGS_TO_ENUM.containsKey((Object)numberFormatType)) {
            String validKeys = Joiner.on((String)"', '").join((Iterable)JS_ARGS_TO_ENUM.keySet());
            throw new IllegalArgumentException("First argument to formatNum must be constant, and one of: '" + validKeys + "'.");
        }
        return numberFormatType;
    }

    private static final class JbcSrcMethods {
        static final MethodRef FORMAT_NUM = MethodRef.create(I18NDirectivesRuntime.class, "formatNum", ULocale.class, Double.TYPE, String.class, String.class, Integer.class, Integer.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

