/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.error.SoyError;
import javax.annotation.Nullable;

public final class SoyErrors {
    public static String getDidYouMeanMessage(Iterable<String> allNames, String wrongName) {
        String closestName = SoyErrors.getClosest(allNames, wrongName);
        if (closestName != null) {
            return String.format(" Did you mean '%s'?", closestName);
        }
        return "";
    }

    public static String getDidYouMeanMessageForProtoFields(ImmutableSet<String> fields, String fieldName) {
        if (fields.contains((Object)(fieldName + "List"))) {
            return String.format(" Did you mean '%sList'?", fieldName);
        }
        return SoyErrors.getDidYouMeanMessage(fields, fieldName);
    }

    @Nullable
    @VisibleForTesting
    static String getClosest(Iterable<String> allNames, String wrongName) {
        int shortest = (wrongName.length() + 2) / 3 + 1;
        String closestName = null;
        for (String otherName : allNames) {
            if (otherName.equals(wrongName)) {
                throw new IllegalArgumentException("'" + wrongName + "' is contained in " + allNames);
            }
            int distance = SoyErrors.distance(otherName, wrongName, shortest);
            if (distance >= shortest) continue;
            shortest = distance;
            closestName = otherName;
            if (distance != 0) continue;
            return closestName;
        }
        return closestName;
    }

    private static int distance(String s, String t, int maxDistance) {
        int i;
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            v1[0] = i + 1;
            int bestThisRow = v1[0];
            char sChar = Ascii.toLowerCase((char)s.charAt(i));
            for (int j = 0; j < t.length(); ++j) {
                char tChar = Ascii.toLowerCase((char)t.charAt(j));
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + (sChar == tChar ? 0 : 1)));
                bestThisRow = Math.min(bestThisRow, v1[j + 1]);
            }
            if (bestThisRow > maxDistance) {
                return maxDistance + 1;
            }
            int[] tmp = v0;
            v0 = v1;
            v1 = tmp;
        }
        return v0[t.length()];
    }

    public static String formatErrors(Iterable<SoyError> errors) {
        int numErrors = 0;
        int numWarnings = 0;
        for (SoyError error : errors) {
            if (error.isWarning()) {
                ++numWarnings;
                continue;
            }
            ++numErrors;
        }
        if (numErrors + numWarnings == 0) {
            throw new IllegalArgumentException("cannot format 0 errors");
        }
        StringBuilder sb = new StringBuilder(numErrors == 0 ? "warnings" : "errors").append(" during Soy compilation\n");
        Joiner.on((char)'\n').appendTo(sb, errors);
        if (numErrors > 0) {
            SoyErrors.formatNumber(numErrors, "error", sb);
        }
        if (numWarnings > 0) {
            if (numErrors > 0) {
                sb.append(' ');
            }
            SoyErrors.formatNumber(numWarnings, "warning", sb);
        }
        return sb.append('\n').toString();
    }

    private static void formatNumber(int n, String type, StringBuilder to) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        to.append(n).append(' ').append(type).append(n == 1 ? "" : "s");
    }
}

