/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ErrorReporterImpl
extends ErrorReporter {
    private final List<SoyError> errors = new ArrayList<SoyError>();
    private final List<SoyError> warnings = new ArrayList<SoyError>();
    private final ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers;

    ErrorReporterImpl(ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers) {
        this.filePathsToSuppliers = filePathsToSuppliers;
    }

    @Override
    public void report(SourceLocation location, SoyErrorKind kind, Object ... args) {
        String message = kind.format(args);
        this.errors.add(SoyError.create(location, kind, message, this.getSnippet(location), false));
    }

    @Override
    public void warn(SourceLocation location, SoyErrorKind kind, Object ... args) {
        String message = kind.format(args);
        this.warnings.add(SoyError.create(location, kind, message, this.getSnippet(location), true));
    }

    @Override
    public ImmutableList<SoyError> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    @Override
    public ImmutableList<SoyError> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    @Override
    int getCurrentNumberOfErrors() {
        return this.errors.size();
    }

    private Optional<String> getSnippet(SourceLocation sourceLocation) {
        Optional<String> snippet = this.getSourceLine(sourceLocation);
        if (snippet.isPresent()) {
            StringBuilder builder = new StringBuilder();
            builder.append((String)snippet.get()).append("\n");
            int beginColumn = Math.max(sourceLocation.getBeginColumn(), 1);
            String caretLine = Strings.repeat((String)" ", (int)(beginColumn - 1)) + "^";
            builder.append(caretLine).append("\n");
            return Optional.of((Object)builder.toString());
        }
        return Optional.absent();
    }

    Optional<String> getSourceLine(SourceLocation sourceLocation) {
        String result;
        SoyFileSupplier supplier = (SoyFileSupplier)this.filePathsToSuppliers.get((Object)sourceLocation.getFilePath());
        if (supplier == null) {
            return Optional.absent();
        }
        try (BufferedReader reader = new BufferedReader(supplier.open());){
            for (int linenum = 1; linenum < sourceLocation.getBeginLine(); ++linenum) {
                reader.readLine();
            }
            result = reader.readLine();
        }
        catch (IOException ioe) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)result);
    }
}

