/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.SanitizedContentKind;
import java.util.EnumSet;

public final class NodeContentKinds {
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"goog.soy.data.SanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"goog.soy.data.SanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"goog.soy.data.SanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"goog.soy.data.SanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"goog.soy.data.SanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"goog.soy.data.SanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContentKind, String> IDOM_KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"Function").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"Function").put((Object)SanitizedContentKind.JS, (Object)"goog.soy.data.SanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"goog.soy.data.SanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"goog.soy.data.SanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"goog.soy.data.SanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_JS_ORDAINER_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"soydata.VERY_UNSAFE.ordainSanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"soydata.VERY_UNSAFE.ordainSanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"soydata.markUnsanitizedText").build();
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedHtmlForInternalBlocks").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedAttributesForInternalBlocks").put((Object)SanitizedContentKind.JS, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedJsForInternalBlocks").put((Object)SanitizedContentKind.URI, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedUriForInternalBlocks").put((Object)SanitizedContentKind.CSS, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedCssForInternalBlocks").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedTrustedResourceUriForInternalBlocks").put((Object)SanitizedContentKind.TEXT, (Object)"soydata.$$markUnsanitizedTextForInternalBlocks").build();
    private static final ImmutableMap<String, String> PROTO_TO_JS_UNPACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedHtml").put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedJs").put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedUri").put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedCss").put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedCss").put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedTrustedResourceUri").build();
    private static final ImmutableMap<String, String> JS_TO_PROTO_PACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedHtmlToProtoSoyRuntimeOnly").put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedJsToProtoSoyRuntimeOnly").put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedUriToProtoSoyRuntimeOnly").put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedCssToSafeStyleProtoSoyRuntimeOnly").put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedCssToSafeStyleSheetProtoSoyRuntimeOnly").put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedTrustedResourceUriToProtoSoyRuntimeOnly").build();
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_PY_SANITIZED_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"sanitize.SanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"sanitize.SanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"sanitize.SanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"sanitize.SanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"sanitize.SanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"sanitize.SanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"sanitize.UnsanitizedText").build();

    public static String toJsSanitizedContentCtorName(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toIDOMSanitizedContentCtorName(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)IDOM_KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainer(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_ORDAINER_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainerForInternalBlocks(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.get((Object)contentKind));
    }

    public static String getJsImportForOrdainersFunctions(SanitizedContentKind contentKind) {
        if (contentKind == SanitizedContentKind.TEXT) {
            return "soydata";
        }
        return "soydata.VERY_UNSAFE";
    }

    public static String toJsPackFunction(Descriptors.Descriptor protoDescriptor) {
        return (String)Preconditions.checkNotNull((Object)JS_TO_PROTO_PACK_FN.get((Object)protoDescriptor.getFullName()));
    }

    public static String toJsUnpackFunction(Descriptors.Descriptor protoDescriptor) {
        return (String)Preconditions.checkNotNull((Object)PROTO_TO_JS_UNPACK_FN.get((Object)protoDescriptor.getFullName()));
    }

    public static String toPySanitizedContentOrdainer(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_PY_SANITIZED_NAME.get((Object)contentKind), (String)"expected to have an ordainer for %s", (Object)((Object)contentKind));
    }

    private NodeContentKinds() {
    }

    static {
        EnumSet<SanitizedContentKind> allKinds = EnumSet.allOf(SanitizedContentKind.class);
        if (!KIND_TO_JS_CTOR_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS constructor");
        }
        if (!IDOM_KIND_TO_JS_CTOR_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all ContentKind enums have a Incremental DOM JS constructor");
        }
        if (!KIND_TO_JS_ORDAINER_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!KIND_TO_PY_SANITIZED_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a Python sanitizer");
        }
    }
}

