/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.Transforms;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SoyMapImpl
extends SoyAbstractValue
implements SoyNewMap {
    private final ImmutableMap<String, ? extends SoyValueProvider> providerMap;

    public static SoyMapImpl forProviderMap(Map<String, ? extends SoyValueProvider> providerMap) {
        return new SoyMapImpl(providerMap);
    }

    private SoyMapImpl(Map<String, ? extends SoyValueProvider> providerMap) {
        this.providerMap = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(providerMap)));
    }

    @Override
    public int size() {
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public final Iterable<? extends SoyValue> keys() {
        return Iterables.transform((Iterable)this.providerMap.keySet(), (Function)new Function<String, SoyValue>(){

            public SoyValue apply(String key) {
                return StringData.forValue(key);
            }
        });
    }

    @Override
    public boolean containsKey(SoyValue key) {
        return this.providerMap.containsKey((Object)key.stringValue());
    }

    @Override
    public SoyValue get(SoyValue key) {
        SoyValueProvider provider = this.getProvider(key);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        return (SoyValueProvider)this.providerMap.get((Object)key.stringValue());
    }

    @Override
    @Nonnull
    public Map<String, ? extends SoyValueProvider> asJavaStringMap() {
        return Collections.unmodifiableMap(this.providerMap);
    }

    @Override
    @Nonnull
    public Map<String, ? extends SoyValue> asResolvedJavaStringMap() {
        return Maps.transformValues(this.asJavaStringMap(), Transforms.RESOLVE_FUNCTION);
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (SoyValue soyValue : this.keys()) {
            SoyValue value = this.get(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.coerceToString();
    }
}

