/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import java.io.IOException;

public abstract class AbstractLoggingAdvisingAppendable
extends LoggingAdvisingAppendable {
    private int logOnlyDepth;

    private boolean isLogOnly() {
        return this.logOnlyDepth > 0;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable append(CharSequence csq) throws IOException {
        if (!this.isLogOnly()) {
            this.doAppend(csq);
        }
        return this;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
        if (!this.isLogOnly()) {
            this.doAppend(csq, start, end);
        }
        return this;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable append(char c) throws IOException {
        if (!this.isLogOnly()) {
            this.doAppend(c);
        }
        return this;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
        if (!this.isLogOnly()) {
            this.doAppendLoggingFunctionInvocation(funCall, escapers);
        }
        return this;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
        int depth = this.logOnlyDepth;
        if (depth > 0) {
            if (++depth < 0) {
                throw new IllegalStateException("overflowed logging depth");
            }
            this.logOnlyDepth = depth;
        } else if (statement.logOnly()) {
            depth = 1;
            this.logOnlyDepth = 1;
        }
        this.doEnterLoggableElement(statement);
        return this;
    }

    @Override
    public final AbstractLoggingAdvisingAppendable exitLoggableElement() {
        int depth = this.logOnlyDepth;
        if (depth > 0) {
            this.logOnlyDepth = --depth;
        }
        this.doExitLoggableElement();
        return this;
    }

    @ForOverride
    protected abstract void doAppend(CharSequence var1) throws IOException;

    @ForOverride
    protected abstract void doAppend(CharSequence var1, int var2, int var3) throws IOException;

    @ForOverride
    protected abstract void doAppend(char var1) throws IOException;

    @ForOverride
    protected abstract void doEnterLoggableElement(LogStatement var1);

    @ForOverride
    protected abstract void doExitLoggableElement();

    @ForOverride
    protected abstract void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation var1, ImmutableList<Function<String, String>> var2) throws IOException;
}

