/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.Sanitizers;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPurePrintDirective
public class NoAutoescapeDirective
implements SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    public static final String NAME = "|noAutoescape";

    @Inject
    public NoAutoescapeDirective() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        return Sanitizers.filterNoAutoescape(value);
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(UnknownType.getInstance(), JbcSrcMethods.FILTER_NO_AUTOESCAPE.invoke(value.box()));
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(JbcSrcMethods.FILTER_NO_AUTOESCAPE_STREAMING.invoke(delegateAppendable));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$filterNoAutoescape(" + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    private static final class JbcSrcMethods {
        static final MethodRef FILTER_NO_AUTOESCAPE = MethodRef.create(Sanitizers.class, "filterNoAutoescape", SoyValue.class);
        static final MethodRef FILTER_NO_AUTOESCAPE_STREAMING = MethodRef.create(Sanitizers.class, "filterNoAutoescapeStreaming", LoggingAdvisingAppendable.class);

        private JbcSrcMethods() {
        }
    }
}

