/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.bididirectives.BidiDirectivesRuntime;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
final class BidiSpanWrapDirective
implements SanitizedContentOperator,
SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiSpanWrapDirective(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "|bidiSpanWrap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    @Nonnull
    public SanitizedContent.ContentKind getContentKind() {
        return SanitizedContent.ContentKind.HTML;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        return StringData.forValue(BidiDirectivesRuntime.bidiSpanWrap((BidiGlobalDir)this.bidiGlobalDirProvider.get(), value));
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return SoyExpression.forString(JbcSrcMethods.BIDI_SPAN_WRAP.invoke(context.getBidiGlobalDir(), value.box()));
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.createCloseable(JbcSrcMethods.BIDI_SPAN_WRAP_STREAMING.invoke(delegateAppendable, context.getBidiGlobalDir()));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String codeSnippet = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet();
        return new JsExpr("soy.$$bidiSpanWrap(" + codeSnippet + ", " + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        String codeSnippet = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet();
        return new PyExpr("bidi.span_wrap(" + codeSnippet + ", " + value.getText() + ")", Integer.MAX_VALUE);
    }

    private static final class JbcSrcMethods {
        static final MethodRef BIDI_SPAN_WRAP = MethodRef.create(BidiDirectivesRuntime.class, "bidiSpanWrap", BidiGlobalDir.class, SoyValue.class).asNonNullable();
        static final MethodRef BIDI_SPAN_WRAP_STREAMING = MethodRef.create(BidiDirectivesRuntime.class, "bidiSpanWrapStreaming", LoggingAdvisingAppendable.class, BidiGlobalDir.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

