/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class MinFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    MinFunction() {
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)2);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg0 = args.get(0);
        SoyValue arg1 = args.get(1);
        return BasicFunctionsRuntime.min(arg0, arg1);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg0 = args.get(0);
        JsExpr arg1 = args.get(1);
        return new JsExpr("Math.min(" + arg0.getText() + ", " + arg1.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg0 = args.get(0);
        PyExpr arg1 = args.get(1);
        PyFunctionExprBuilder fnBuilder = new PyFunctionExprBuilder("min");
        return fnBuilder.addArg(arg0).addArg(arg1).asPyExpr();
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression left = args.get(0);
        SoyExpression right = args.get(1);
        if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
            return SoyExpression.forInt(JbcSrcMethods.MATH_MIN_LONG.invoke(left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
        }
        if (left.assignableToNullableFloat() && right.assignableToNullableFloat()) {
            return SoyExpression.forFloat(JbcSrcMethods.MATH_MIN_DOUBLE.invoke(left.unboxAs(Double.TYPE), right.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, JbcSrcMethods.MIN_FN.invoke(left.box(), right.box()));
    }

    private static final class JbcSrcMethods {
        static final MethodRef MATH_MIN_DOUBLE = MethodRef.create(Math.class, "min", Double.TYPE, Double.TYPE).asCheap();
        static final MethodRef MATH_MIN_LONG = MethodRef.create(Math.class, "min", Long.TYPE, Long.TYPE).asCheap();
        static final MethodRef MIN_FN = MethodRef.create(BasicFunctionsRuntime.class, "min", SoyValue.class, SoyValue.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

