/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyPureFunction
public final class CeilingFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    CeilingFunction() {
    }

    @Override
    public String getName() {
        return "ceiling";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        return IntegerData.forValue(BasicFunctionsRuntime.ceil(args.get(0)));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg = args.get(0);
        return new JsExpr("Math.ceil(" + arg.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg = args.get(0);
        return new PyExpr("int(math.ceil(" + arg.getText() + "))", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression argument = args.get(0);
        switch (argument.resultType().getSort()) {
            case 7: {
                return argument;
            }
            case 8: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(JbcSrcMethods.MATH_CEIL.invoke(argument), Type.LONG_TYPE));
            }
        }
        return SoyExpression.forInt(JbcSrcMethods.CEIL_FN.invoke(argument.box()));
    }

    private static final class JbcSrcMethods {
        static final MethodRef CEIL_FN = MethodRef.create(BasicFunctionsRuntime.class, "ceil", SoyValue.class).asCheap();
        static final MethodRef MATH_CEIL = MethodRef.create(Math.class, "ceil", Double.TYPE).asCheap();

        private JbcSrcMethods() {
        }
    }
}

