/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.StringData;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class BasicDirectivesRuntime {
    private static final Logger logger = Logger.getLogger(BasicDirectivesRuntime.class.getName());
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");

    public static String truncate(String str, int maxLen, boolean doAddEllipsis) {
        if (str.length() <= maxLen) {
            return str;
        }
        if (doAddEllipsis) {
            if (maxLen > 3) {
                maxLen -= 3;
            } else {
                doAddEllipsis = false;
            }
        }
        if (Character.isHighSurrogate(str.charAt(maxLen - 1)) && Character.isLowSurrogate(str.charAt(maxLen))) {
            --maxLen;
        }
        str = str.substring(0, maxLen);
        if (doAddEllipsis) {
            str = str + "...";
        }
        return str;
    }

    public static LoggingAdvisingAppendable truncateStreaming(LoggingAdvisingAppendable appendable, int maxLength, boolean addEllipsis) {
        return new TruncateAppendable(appendable, maxLength, addEllipsis);
    }

    public static SoyString changeNewlineToBr(SoyValue value) {
        SanitizedContent sanitizedContent;
        String result = NEWLINE_PATTERN.matcher(BasicDirectivesRuntime.coerceToString(value)).replaceAll("<br>");
        if (value instanceof SanitizedContent && (sanitizedContent = (SanitizedContent)value).getContentKind() == SanitizedContent.ContentKind.HTML) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(result, SanitizedContent.ContentKind.HTML, sanitizedContent.getContentDirection());
        }
        return StringData.forValue(result);
    }

    public static LoggingAdvisingAppendable changeNewlineToBrStreaming(LoggingAdvisingAppendable appendable) {
        return new ForwardingLoggingAdvisingAppendable(appendable){
            private boolean lastCharWasCarriageReturn;

            @Override
            public LoggingAdvisingAppendable append(char c) throws IOException {
                switch (c) {
                    case '\n': {
                        if (!this.lastCharWasCarriageReturn) {
                            super.append("<br>");
                        }
                        this.lastCharWasCarriageReturn = false;
                        break;
                    }
                    case '\r': {
                        super.append("<br>");
                        this.lastCharWasCarriageReturn = true;
                        break;
                    }
                    default: {
                        super.append(c);
                        this.lastCharWasCarriageReturn = false;
                    }
                }
                return this;
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
                int appendedUpTo = start;
                boolean carriageReturn = this.lastCharWasCarriageReturn;
                block4: for (int i = start; i < end; ++i) {
                    switch (csq.charAt(i)) {
                        case '\n': {
                            this.appendUpTo(csq, appendedUpTo, i);
                            if (!carriageReturn) {
                                super.append("<br>");
                            }
                            appendedUpTo = i + 1;
                            carriageReturn = false;
                            continue block4;
                        }
                        case '\r': {
                            this.appendUpTo(csq, appendedUpTo, i);
                            super.append("<br>");
                            appendedUpTo = i + 1;
                            carriageReturn = true;
                            continue block4;
                        }
                        default: {
                            carriageReturn = false;
                        }
                    }
                }
                this.appendUpTo(csq, appendedUpTo, end);
                this.lastCharWasCarriageReturn = carriageReturn;
                return this;
            }

            private void appendUpTo(CharSequence csq, int start, int end) throws IOException {
                if (start != end) {
                    super.append(csq, start, end);
                }
            }
        };
    }

    public static SoyString insertWordBreaks(SoyValue value, int maxCharsBetweenWordBreaks) {
        SanitizedContent sanitizedContent;
        String result = new InsertWordBreaks(maxCharsBetweenWordBreaks).processString(BasicDirectivesRuntime.coerceToString(value));
        if (value instanceof SanitizedContent && (sanitizedContent = (SanitizedContent)value).getContentKind() == SanitizedContent.ContentKind.HTML) {
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(result, SanitizedContent.ContentKind.HTML, sanitizedContent.getContentDirection());
        }
        return StringData.forValue(result);
    }

    public static LoggingAdvisingAppendable insertWordBreaksStreaming(LoggingAdvisingAppendable appendable, final int maxCharsBetweenWordBreaks) {
        return new ForwardingLoggingAdvisingAppendable(appendable){
            private final InsertWordBreaks insertWordBreaks;
            {
                super(delegate);
                this.insertWordBreaks = new InsertWordBreaks(maxCharsBetweenWordBreaks);
            }

            @Override
            public LoggingAdvisingAppendable append(char c) throws IOException {
                this.delegate.append(this.insertWordBreaks.processChar(c));
                return this;
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq) throws IOException {
                this.delegate.append(this.insertWordBreaks.processString(csq.toString()));
                return this;
            }

            @Override
            public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) throws IOException {
                this.delegate.append(this.insertWordBreaks.processString(csq.subSequence(start, end).toString()));
                return this;
            }
        };
    }

    private static String coerceToString(@Nullable SoyValue v) {
        return v == null ? "null" : v.coerceToString();
    }

    private static final class InsertWordBreaks {
        private final int maxCharsBetweenWordBreaks;
        private final StringBuilder result;
        private boolean isInTag;
        private boolean isMaybeInEntity;
        private int numCharsWithoutBreak;

        InsertWordBreaks(int maxCharsBetweenWordBreaks) {
            this.maxCharsBetweenWordBreaks = maxCharsBetweenWordBreaks;
            this.result = new StringBuilder();
        }

        String processString(String str) {
            int codePoint;
            int n = str.length();
            for (int i = 0; i < n; i += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(i);
                this.processOneCodePoint(codePoint);
            }
            return this.getAndReset();
        }

        String processChar(char c) {
            this.processOneCodePoint(c);
            return this.getAndReset();
        }

        private String getAndReset() {
            String resultStr = this.result.toString();
            this.result.setLength(0);
            return resultStr;
        }

        private void processOneCodePoint(int codePoint) {
            if (this.numCharsWithoutBreak >= this.maxCharsBetweenWordBreaks && codePoint != 32) {
                this.result.append("<wbr>");
                this.numCharsWithoutBreak = 0;
            }
            if (this.isInTag) {
                if (codePoint == 62) {
                    this.isInTag = false;
                }
            } else if (this.isMaybeInEntity) {
                switch (codePoint) {
                    case 59: {
                        this.isMaybeInEntity = false;
                        ++this.numCharsWithoutBreak;
                        break;
                    }
                    case 60: {
                        this.isMaybeInEntity = false;
                        this.isInTag = true;
                        break;
                    }
                    case 32: {
                        this.isMaybeInEntity = false;
                        this.numCharsWithoutBreak = 0;
                        break;
                    }
                }
            } else {
                switch (codePoint) {
                    case 60: {
                        this.isInTag = true;
                        break;
                    }
                    case 38: {
                        this.isMaybeInEntity = true;
                        break;
                    }
                    case 32: {
                        this.numCharsWithoutBreak = 0;
                        break;
                    }
                    default: {
                        ++this.numCharsWithoutBreak;
                    }
                }
            }
            this.result.appendCodePoint(codePoint);
        }
    }

    private static final class TruncateAppendable
    extends LoggingAdvisingAppendable
    implements Closeable {
        private final StringBuilder buffer = new StringBuilder();
        private final LoggingAdvisingAppendable delegate;
        private final int maxLength;
        private final boolean addEllipsis;

        TruncateAppendable(LoggingAdvisingAppendable delegate, int maxLength, boolean addEllipsis) {
            this.delegate = delegate;
            this.maxLength = maxLength;
            this.addEllipsis = addEllipsis;
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq) {
            this.buffer.append(csq);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(CharSequence csq, int start, int end) {
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable append(char c) {
            this.buffer.append(c);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            logger.log(Level.WARNING, "Visual element logging behavior is undefined when used with the |truncate directive. This logging call has been dropped: {0}", statement);
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            return this;
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            this.delegate.setSanitizedContentKind(SanitizedContent.ContentKind.TEXT);
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) {
            this.buffer.append(TruncateAppendable.escapePlaceholder(funCall.placeholderValue(), escapers));
            return this;
        }

        @Override
        public boolean softLimitReached() {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.delegate.append(BasicDirectivesRuntime.truncate(this.buffer.toString(), this.maxLength, this.addEllipsis));
        }
    }
}

