/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractReturningNodeVisitor<N extends Node, R>
implements NodeVisitor<N, R> {
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    @Override
    public R exec(N node) {
        return this.visit(node);
    }

    protected abstract R visit(N var1);

    protected List<R> visitChildren(ParentNode<? extends N> node) {
        ArrayList<R> results = new ArrayList<R>(node.numChildren());
        for (Node child : node.getChildren()) {
            results.add(this.visit(child));
        }
        return results;
    }

    protected List<R> visitChildrenAllowingConcurrentModification(ParentNode<? extends N> node) {
        ArrayList<R> results = new ArrayList<R>(node.numChildren());
        Node[] nodeArray = node.getChildren().toArray(EMPTY_NODE_ARRAY);
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node child;
            Node typedChild = child = nodeArray[i];
            results.add(this.visit(typedChild));
        }
        return results;
    }
}

