/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import java.util.List;

public abstract class AbstractNodeVisitor<N extends Node, R>
implements NodeVisitor<N, R> {
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    @Override
    public R exec(N node) {
        this.visit(node);
        return null;
    }

    protected abstract void visit(N var1);

    protected void visitChildren(ParentNode<? extends N> node) {
        List<N> children = node.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            this.visit((Node)children.get(i));
        }
    }

    protected void visitChildrenAllowingConcurrentModification(ParentNode<? extends N> node) {
        Node[] nodeArray = node.getChildren().toArray(EMPTY_NODE_ARRAY);
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node child;
            Node typedChild = child = nodeArray[i];
            this.visit(typedChild);
        }
    }
}

