/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;

public final class SoyProtoValueImpl
extends SoyAbstractValue
implements SoyProtoValue,
SoyMap {
    private static final LoadingCache<Descriptors.Descriptor, ProtoClass> classCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoClass>(){

        public ProtoClass load(Descriptors.Descriptor descriptor) throws Exception {
            LinkedHashSet<Descriptors.FieldDescriptor> extensions = new LinkedHashSet<Descriptors.FieldDescriptor>();
            return new ProtoClass(SoyProtoValueImpl.getDefaultInstance(descriptor), Field.getFieldsForType(null, descriptor, extensions));
        }
    });
    private final Message proto;
    private ProtoClass clazz;

    private static Message getDefaultInstance(Descriptors.Descriptor key) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> messageClass = Class.forName(JavaQualifiedNames.getClassName(key));
        return (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
    }

    public static SoyProtoValueImpl create(Message proto) {
        return new SoyProtoValueImpl(proto);
    }

    private SoyProtoValueImpl(Message proto) {
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
    }

    private ProtoClass clazz() {
        ProtoClass localClazz = this.clazz;
        if (localClazz == null) {
            this.clazz = localClazz = (ProtoClass)classCache.getUnchecked((Object)this.proto.getDescriptorForType());
        }
        return localClazz;
    }

    @Override
    public Message getProto() {
        return this.proto;
    }

    @Override
    public SoyValue getProtoField(String name) {
        Field field = (Field)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        if (field.shouldCheckFieldPresenceToEmulateJspbNullability() && !this.proto.hasField(field.getDescriptor())) {
            return NullData.INSTANCE;
        }
        return field.interpretField(this.proto).resolve();
    }

    @Override
    @Deprecated
    public boolean hasField(String name) {
        Field field = (Field)this.clazz().fields.get((Object)name);
        if (field == null) {
            return false;
        }
        return field.hasField(this.proto);
    }

    @Override
    @Deprecated
    public SoyValue getField(String name) {
        SoyValueProvider valueProvider = this.getFieldProvider(name);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getFieldProvider(String name) {
        return this.getFieldProviderInternal(name);
    }

    private SoyValueProvider getFieldProviderInternal(String name) {
        if (!this.hasField(name)) {
            return null;
        }
        return ((Field)this.clazz().fields.get((Object)name)).interpretField(this.proto).resolve();
    }

    @Override
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    public Collection<SoyValue> getItemKeys() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : this.clazz().fields.keySet()) {
            if (!this.hasField(key)) continue;
            builder.add((Object)StringData.forValue(key));
        }
        return builder.build();
    }

    @Override
    public boolean hasItem(SoyValue key) {
        return this.hasField(key.stringValue());
    }

    @Override
    public SoyValue getItem(SoyValue key) {
        return this.getField(key.stringValue());
    }

    @Override
    public SoyValueProvider getItemProvider(SoyValue key) {
        return this.getFieldProvider(key.stringValue());
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValueImpl)other).proto;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        TextFormat.print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    public String toString() {
        return String.format("SoyProtoValue<%s>", this.proto.getDescriptorForType().getFullName());
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    public static final class Builder {
        private final ProtoClass clazz;
        private final Message.Builder builder;

        public Builder(Descriptors.Descriptor soyProto) {
            this.clazz = (ProtoClass)classCache.getUnchecked((Object)soyProto);
            this.builder = this.clazz.defaultInstance.newBuilderForType();
        }

        public Builder setField(String field, SoyValue value) {
            ((Field)this.clazz.fields.get((Object)field)).assignField(this.builder, value);
            return this;
        }

        public SoyProtoValueImpl build() {
            SoyProtoValueImpl soyProtoValueImpl = new SoyProtoValueImpl(this.builder.build());
            soyProtoValueImpl.clazz = this.clazz;
            return soyProtoValueImpl;
        }
    }

    private static final class ProtoClass {
        final ImmutableMap<String, Field> fields;
        final Message defaultInstance;

        ProtoClass(Message defaultInstance, ImmutableMap<String, Field> fields) {
            this.defaultInstance = (Message)Preconditions.checkNotNull((Object)defaultInstance);
            this.fields = (ImmutableMap)Preconditions.checkNotNull(fields);
        }
    }
}

