/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.FieldInterpreter;
import com.google.template.soy.types.proto.ProtoUtils;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class NormalField
extends Field {
    @Nullable
    private final SoyTypeRegistry typeRegistry;
    protected final Descriptors.FieldDescriptor fieldDescriptor;
    protected final String name;
    private final boolean shouldCheckFieldPresenceToEmulateJspbNullability;
    @GuardedBy(value="this")
    private volatile FieldInterpreter interpreter;

    NormalField(@Nullable SoyTypeRegistry typeRegistry, Descriptors.FieldDescriptor desc) {
        this.typeRegistry = typeRegistry;
        this.fieldDescriptor = desc;
        this.name = NormalField.computeSoyName(desc);
        this.shouldCheckFieldPresenceToEmulateJspbNullability = ProtoUtils.shouldCheckFieldPresenceToEmulateJspbNullability(desc);
    }

    @Override
    public boolean shouldCheckFieldPresenceToEmulateJspbNullability() {
        return this.shouldCheckFieldPresenceToEmulateJspbNullability;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public SoyType getType() {
        Preconditions.checkState((this.typeRegistry != null ? 1 : 0) != 0, (Object)"cannot lookup types from runtime fields... why try?");
        return this.impl().type(this.typeRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldInterpreter impl() {
        FieldInterpreter local = this.interpreter;
        if (local == null) {
            NormalField normalField = this;
            synchronized (normalField) {
                local = this.interpreter;
                if (local == null) {
                    this.interpreter = local = FieldInterpreter.create(this.fieldDescriptor);
                }
            }
        }
        return local;
    }

    @Override
    public boolean hasField(Message proto) {
        return !this.shouldCheckFieldPresenceToEmulateJspbNullability || proto.hasField(this.fieldDescriptor);
    }

    @Override
    public SoyValueProvider interpretField(Message message) {
        return this.impl().soyFromProto(message.getField(this.fieldDescriptor));
    }

    @Override
    public void assignField(Message.Builder builder, SoyValue value) {
        builder.setField(this.fieldDescriptor, this.impl().protoFromSoy(value));
    }

    @Override
    public Descriptors.FieldDescriptor getDescriptor() {
        return this.fieldDescriptor;
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName()) + NormalField.fieldSuffix(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            if (ProtoUtils.hasJsMapKey(field)) {
                return "Map";
            }
            return "List";
        }
        return "";
    }
}

