/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.AmbiguousFieldSet;
import com.google.template.soy.types.proto.ExtensionField;
import com.google.template.soy.types.proto.NormalField;
import com.google.template.soy.types.proto.ProtoUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class Field {
    private static final Logger logger = Logger.getLogger(Field.class.getName());

    Field() {
    }

    static ImmutableMap<String, Field> getFieldsForType(@Nullable SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) continue;
            NormalField normalField = new NormalField(typeRegistry, fieldDescriptor);
            fields.put((Object)normalField.getName(), (Object)normalField);
        }
        SetMultimap extensionsBySoyName = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Descriptors.FieldDescriptor fieldDescriptor : extensions) {
            ExtensionField field = new ExtensionField(typeRegistry, fieldDescriptor);
            extensionsBySoyName.put((Object)field.getName(), (Object)field);
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)extensionsBySoyName).entrySet()) {
            String fieldName = (String)entry.getKey();
            Set ambiguousFields = (Set)entry.getValue();
            if (ambiguousFields.size() == 1) {
                fields.put((Object)fieldName, Iterables.getOnlyElement((Iterable)ambiguousFields));
                continue;
            }
            AmbiguousFieldSet value = new AmbiguousFieldSet(fieldName, ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + value.getFullFieldNames() + "\nThis field will not be accessible from soy");
            fields.put((Object)fieldName, (Object)value);
        }
        return fields.build();
    }

    abstract String getName();

    abstract SoyType getType();

    abstract boolean hasField(Message var1);

    abstract boolean shouldCheckFieldPresenceToEmulateJspbNullability();

    abstract SoyValueProvider interpretField(Message var1);

    abstract void assignField(Message.Builder var1, SoyValue var2);

    abstract Descriptors.FieldDescriptor getDescriptor();
}

