/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.proto.ExtensionField;
import com.google.template.soy.types.proto.Field;
import java.util.Set;

final class AmbiguousFieldSet
extends Field {
    private final String name;
    private final ImmutableSet<ExtensionField> extensions;
    private final ImmutableSet<String> fullFieldNames;

    AmbiguousFieldSet(String name, Set<ExtensionField> fields) {
        Preconditions.checkArgument((fields.size() > 1 ? 1 : 0) != 0);
        this.name = name;
        this.extensions = ImmutableSet.copyOf(fields);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ExtensionField field : fields) {
            builder.add((Object)field.fieldDescriptor.getFullName());
        }
        this.fullFieldNames = builder.build();
    }

    ImmutableSet<String> getFullFieldNames() {
        return this.fullFieldNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SoyType getType() {
        throw this.failure();
    }

    @Override
    public boolean shouldCheckFieldPresenceToEmulateJspbNullability() {
        throw this.failure();
    }

    @Override
    boolean hasField(Message proto) {
        for (ExtensionField extension : this.extensions) {
            if (!extension.hasField(proto)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Descriptors.FieldDescriptor getDescriptor() {
        throw this.failure();
    }

    @Override
    public SoyValueProvider interpretField(Message owningMessage) {
        throw this.failure();
    }

    @Override
    public void assignField(Message.Builder builder, SoyValue value) {
        throw this.failure();
    }

    private RuntimeException failure() {
        return new IllegalStateException(String.format("Cannot access $%s. It may refer to any one of the following extensions, and Soy doesn't have enough information to decide which.\n%s\nTo resolve ensure that all extension fields accessed from soy have unique names.", this.name, this.fullFieldNames));
    }
}

