/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.aggregate;

import com.google.common.base.Preconditions;
import com.google.template.soy.types.SoyType;
import java.util.Objects;

public final class MapType
implements SoyType {
    public static final MapType EMPTY_MAP = new MapType(null, null);
    private final SoyType keyType;
    private final SoyType valueType;

    private MapType(SoyType keyType, SoyType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static MapType of(SoyType keyType, SoyType valueType) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        return new MapType(keyType, valueType);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.MAP;
    }

    public SoyType getKeyType() {
        return this.keyType;
    }

    public SoyType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isAssignableFrom(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.MAP) {
            MapType srcMapType = (MapType)srcType;
            if (srcMapType == EMPTY_MAP) {
                return true;
            }
            if (this == EMPTY_MAP) {
                return false;
            }
            return this.keyType.isAssignableFrom(srcMapType.keyType) && this.valueType.isAssignableFrom(srcMapType.valueType);
        }
        return false;
    }

    public String toString() {
        return "map<" + this.keyType + "," + this.valueType + ">";
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            MapType otherMap = (MapType)other;
            return Objects.equals(otherMap.keyType, this.keyType) && Objects.equals(otherMap.valueType, this.valueType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.keyType, this.valueType);
    }
}

