/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class TemplateRegistry {
    private static final SoyErrorKind DUPLICATE_TEMPLATES = SoyErrorKind.of("Template ''{0}'' already defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BASIC_AND_DELTEMPLATE_WITH_SAME_NAME = SoyErrorKind.of("Found deltemplate {0} with the same name as a basic template at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DEFAULT_DELEGATE_TEMPLATES = SoyErrorKind.of("Delegate template ''{0}'' already has a default defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE = SoyErrorKind.of("Delegate template ''{0}'' already defined in delpackage {1}: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ImmutableMap<String, TemplateBasicNode> basicTemplatesMap;
    private final DelTemplateSelector<TemplateDelegateNode> delTemplateSelector;
    private final ImmutableList<TemplateNode> allTemplates;

    public TemplateRegistry(SoyFileSetNode soyTree, ErrorReporter errorReporter) {
        ImmutableList.Builder allTemplatesBuilder = ImmutableList.builder();
        DelTemplateSelector.Builder<TemplateDelegateNode> delTemplateSelectorBuilder = new DelTemplateSelector.Builder<TemplateDelegateNode>();
        LinkedHashMap<String, TemplateBasicNode> basicTemplates = new LinkedHashMap<String, TemplateBasicNode>();
        HashMultimap delegateTemplates = HashMultimap.create();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            for (TemplateNode template : soyFile.getChildren()) {
                TemplateDelegateNode previous;
                allTemplatesBuilder.add((Object)template);
                if (template instanceof TemplateBasicNode) {
                    TemplateBasicNode prev = basicTemplates.put(template.getTemplateName(), (TemplateBasicNode)template);
                    if (prev == null) continue;
                    errorReporter.report(template.getSourceLocation(), DUPLICATE_TEMPLATES, template.getTemplateName(), prev.getSourceLocation());
                    continue;
                }
                TemplateDelegateNode delTemplate = (TemplateDelegateNode)template;
                String delTemplateName = delTemplate.getDelTemplateName();
                String delPackageName = delTemplate.getDelPackageName();
                String variant = delTemplate.getDelTemplateVariant();
                if (delPackageName == null) {
                    previous = delTemplateSelectorBuilder.addDefault(delTemplateName, variant, delTemplate);
                    if (previous != null) {
                        errorReporter.report(delTemplate.getSourceLocation(), DUPLICATE_DEFAULT_DELEGATE_TEMPLATES, delTemplateName, previous.getSourceLocation());
                    }
                } else {
                    previous = delTemplateSelectorBuilder.add(delTemplateName, delPackageName, variant, delTemplate);
                    if (previous != null) {
                        errorReporter.report(delTemplate.getSourceLocation(), DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE, delTemplateName, delPackageName, previous.getSourceLocation());
                    }
                }
                delegateTemplates.put((Object)delTemplateName, (Object)delTemplate);
            }
        }
        for (Map.Entry entry : delegateTemplates.entries()) {
            TemplateBasicNode basicNode = (TemplateBasicNode)basicTemplates.get(entry.getKey());
            if (basicNode == null) continue;
            errorReporter.report(((TemplateDelegateNode)entry.getValue()).getSourceLocation(), BASIC_AND_DELTEMPLATE_WITH_SAME_NAME, entry.getKey(), basicNode.getSourceLocation());
        }
        this.basicTemplatesMap = ImmutableMap.copyOf(basicTemplates);
        this.delTemplateSelector = delTemplateSelectorBuilder.build();
        this.allTemplates = allTemplatesBuilder.build();
    }

    public ImmutableMap<String, TemplateBasicNode> getBasicTemplatesMap() {
        return this.basicTemplatesMap;
    }

    @Nullable
    public TemplateBasicNode getBasicTemplate(String templateName) {
        return (TemplateBasicNode)this.basicTemplatesMap.get((Object)templateName);
    }

    public DelTemplateSelector<TemplateDelegateNode> getDelTemplateSelector() {
        return this.delTemplateSelector;
    }

    public ImmutableList<TemplateNode> getAllTemplates() {
        return this.allTemplates;
    }

    @Nullable
    public TemplateDelegateNode selectDelTemplate(TemplateDelegateNode.DelTemplateKey delTemplateKey, Predicate<String> activeDelPackageNameSelector) {
        return this.delTemplateSelector.selectTemplate(delTemplateKey.name(), delTemplateKey.variant(), activeDelPackageNameSelector);
    }

    public Optional<SanitizedContentKind> getCallContentKind(CallNode node) {
        TemplateNode templateNode = null;
        if (node instanceof CallBasicNode) {
            String calleeName = ((CallBasicNode)node).getCalleeName();
            templateNode = this.getBasicTemplate(calleeName);
        } else {
            String calleeName = ((CallDelegateNode)node).getDelCalleeName();
            ImmutableList templateNodes = this.getDelTemplateSelector().delTemplateNameToValues().get((Object)calleeName);
            if (!templateNodes.isEmpty()) {
                templateNode = (TemplateNode)templateNodes.get(0);
            }
        }
        if (templateNode == null) {
            return Optional.absent();
        }
        Preconditions.checkState((templateNode instanceof TemplateBasicNode || templateNode.getAutoescapeMode() == AutoescapeMode.STRICT ? 1 : 0) != 0, (Object)"Cannot determine the content kind for a delegate template that does not use strict autoescaping.");
        return Optional.of((Object)((Object)templateNode.getContentKind()));
    }
}

