/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;
import javax.annotation.Nullable;

public class TemplateBasicNodeBuilder
extends TemplateNodeBuilder {
    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateBasicNodeBuilder setId(int id) {
        return (TemplateBasicNodeBuilder)super.setId(id);
    }

    @Override
    public TemplateBasicNodeBuilder setSourceLocation(SourceLocation location) {
        return (TemplateBasicNodeBuilder)super.setSourceLocation(location);
    }

    @Override
    public TemplateNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        AutoescapeMode autoescapeMode = this.soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContentKind kind = null;
        SourceLocation kindLocation = null;
        this.visibility = Visibility.PUBLIC;
        block18: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            switch (name.identifier()) {
                case "visibility": {
                    this.visibility = attribute.valueAsVisibility(this.errorReporter);
                    continue block18;
                }
                case "autoescape": {
                    autoescapeMode = attribute.valueAsAutoescapeMode(this.errorReporter);
                    continue block18;
                }
                case "kind": {
                    kind = attribute.valueAsContentKind(this.errorReporter);
                    kindLocation = attribute.getValueLocation();
                    continue block18;
                }
                case "requirecss": {
                    this.setRequiredCssNamespaces(attribute.valueAsRequireCss(this.errorReporter));
                    continue block18;
                }
                case "cssbase": {
                    this.setCssBaseNamespace(attribute.valueAsCssBase(this.errorReporter));
                    continue block18;
                }
                case "deprecatedV1": {
                    this.markDeprecatedV1(attribute.valueAsBoolean(this.errorReporter, false));
                    continue block18;
                }
                case "stricthtml": {
                    this.strictHtmlMode = attribute.valueAsTriState(this.errorReporter);
                    continue block18;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), "template", ImmutableList.of((Object)"visibility", (Object)"autoescape", (Object)"kind", (Object)"requirecss", (Object)"cssbase", (Object)"deprecatedV1", (Object)"stricthtml"));
        }
        this.setAutoescapeInfo(autoescapeMode, kind, kindLocation);
        this.setTemplateNames(this.soyFileHeaderInfo.namespace + templateName.identifier(), templateName.location(), templateName.identifier());
        this.templateNameForUserMsgs = this.getTemplateName();
        return this;
    }

    public TemplateBasicNodeBuilder setCmdTextInfo(String templateName, @Nullable String partialTemplateName, Visibility visibility, AutoescapeMode autoescapeMode, SanitizedContentKind contentKind, ImmutableList<String> requiredCssNamespaces) {
        Preconditions.checkState((this.sourceLocation != null ? 1 : 0) != 0);
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(templateName));
        Preconditions.checkArgument((partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName) ? 1 : 0) != 0);
        Preconditions.checkArgument((contentKind != null == (autoescapeMode == AutoescapeMode.STRICT) ? 1 : 0) != 0);
        this.setTemplateNames(templateName, this.sourceLocation, partialTemplateName);
        this.templateNameForUserMsgs = templateName;
        this.visibility = visibility;
        this.setAutoescapeInfo(autoescapeMode, contentKind, this.sourceLocation);
        this.setRequiredCssNamespaces(requiredCssNamespaces);
        StringBuilder cmdTextBuilder = new StringBuilder();
        cmdTextBuilder.append(partialTemplateName != null ? partialTemplateName : templateName);
        cmdTextBuilder.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (contentKind != null) {
            cmdTextBuilder.append(" kind=\"").append(contentKind.asAttributeValue()).append('\"');
        }
        if (visibility != Visibility.PUBLIC) {
            cmdTextBuilder.append(" visibility=\"").append(visibility.getAttributeValue()).append("\"");
        }
        if (!requiredCssNamespaces.isEmpty()) {
            cmdTextBuilder.append(" requirecss=\"").append(Joiner.on((String)", ").join(requiredCssNamespaces)).append("\"");
        }
        this.cmdText = cmdTextBuilder.toString();
        return this;
    }

    @Override
    public TemplateBasicNodeBuilder setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        return (TemplateBasicNodeBuilder)super.setSoyDoc(soyDoc, soyDocLocation);
    }

    @Override
    public TemplateBasicNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        return (TemplateBasicNodeBuilder)super.addParams(allParams);
    }

    @Override
    public TemplateBasicNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateBasicNode(this, this.soyFileHeaderInfo, this.visibility, (ImmutableList<TemplateParam>)this.params);
    }
}

