/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyNode;

public final class LetValueNode
extends LetNode
implements SoyNode.ExprHolderNode {
    private final ExprRootNode valueExpr;

    public LetValueNode(int id, SourceLocation location, String varName, ExprNode expr) {
        super(id, location, varName);
        this.valueExpr = new ExprRootNode(expr);
    }

    private LetValueNode(LetValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.valueExpr = orig.valueExpr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.LET_VALUE_NODE;
    }

    public ExprRootNode getExpr() {
        return this.valueExpr;
    }

    @Override
    public String getCommandText() {
        return "$" + this.getVarName() + " : " + this.getExpr().toSourceString();
    }

    @Override
    public String getTagString() {
        return this.getTagString(true);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.valueExpr);
    }

    @Override
    public LetValueNode copy(CopyState copyState) {
        return new LetValueNode(this, copyState);
    }
}

