/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;

public final class CssNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode {
    private final String selectorText;
    private Pair<SoyCssRenamingMap, String> renameCache;

    public CssNode(int id, SourceLocation location, String selectorText) {
        super(id, location, "css");
        this.selectorText = (String)Preconditions.checkNotNull((Object)selectorText);
    }

    private CssNode(CssNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selectorText = orig.selectorText;
    }

    public CssNode(CssNode orig, String newSelectorText, CopyState copyState) {
        super(orig, copyState);
        this.selectorText = newSelectorText;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CSS_NODE;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    public String getRenamedSelectorText(SoyCssRenamingMap cssRenamingMap) {
        Pair<SoyCssRenamingMap, String> cache = this.renameCache;
        if (cache != null && cache.first == cssRenamingMap) {
            return (String)cache.second;
        }
        String mappedText = cssRenamingMap.get(this.selectorText);
        if (mappedText != null) {
            this.renameCache = Pair.of(cssRenamingMap, mappedText);
            return mappedText;
        }
        return this.selectorText;
    }

    @Override
    public String getCommandText() {
        return this.selectorText;
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public CssNode copy(CopyState copyState) {
        return new CssNode(this, copyState);
    }
}

