/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;

final class ResolvePackageRelativeCssNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final String RELATIVE_SELECTOR_PREFIX = "%";
    private static final SoyErrorKind PACKAGE_RELATIVE_CLASS_NAME_USED_WITH_COMPONENT_NAME = SoyErrorKind.of("Package-relative class name ''{0}'' cannot be used with component expression.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_CSS_PACKAGE = SoyErrorKind.of("No CSS package defined for package-relative class name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private String packagePrefix = null;

    ResolvePackageRelativeCssNamesVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getCssBaseNamespace());
        } else if (node.getParent().getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getParent().getCssBaseNamespace());
        } else if (!node.getParent().getRequiredCssNamespaces().isEmpty()) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase((String)node.getParent().getRequiredCssNamespaces().get(0));
        }
        List<CssNode> cssNodes = SoyTreeUtils.getAllNodesOfType(node, CssNode.class);
        for (CssNode css : cssNodes) {
            this.resolveSelector(css);
        }
        List<FunctionNode> fnNodes = SoyTreeUtils.getAllNodesOfType(node, FunctionNode.class);
        for (FunctionNode fn : fnNodes) {
            this.resolveSelector(fn);
        }
    }

    private void resolveSelector(CssNode node) {
        String selectorText = node.getSelectorText();
        if (!selectorText.startsWith(RELATIVE_SELECTOR_PREFIX)) {
            return;
        }
        if (this.packagePrefix == null) {
            this.errorReporter.report(node.getSourceLocation(), NO_CSS_PACKAGE, selectorText);
        }
        String prefixed = this.packagePrefix + selectorText.substring(RELATIVE_SELECTOR_PREFIX.length());
        CssNode newNode = new CssNode(node, prefixed, new CopyState());
        ParentNode parent = node.getParent();
        parent.replaceChild(node, newNode);
    }

    private void resolveSelector(FunctionNode node) {
        if (node.getSoyFunction() != BuiltinFunction.CSS) {
            return;
        }
        ExprNode lastChild = (ExprNode)Iterables.getLast(node.getChildren());
        if (!(lastChild instanceof StringNode)) {
            return;
        }
        StringNode selector = (StringNode)Iterables.getLast(node.getChildren());
        String selectorText = selector.getValue();
        if (!selectorText.startsWith(RELATIVE_SELECTOR_PREFIX)) {
            return;
        }
        if (node.numChildren() > 1) {
            this.errorReporter.report(selector.getSourceLocation(), PACKAGE_RELATIVE_CLASS_NAME_USED_WITH_COMPONENT_NAME, selectorText);
        }
        if (this.packagePrefix == null) {
            this.errorReporter.report(selector.getSourceLocation(), NO_CSS_PACKAGE, selectorText);
        }
        String prefixed = this.packagePrefix + selectorText.substring(RELATIVE_SELECTOR_PREFIX.length());
        StringNode newSelector = new StringNode(prefixed, selector.getSourceLocation());
        node.replaceChild(selector, (ExprNode)newSelector);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    private static String toCamelCase(String packageName) {
        String packageNameWithDashes = packageName.replace('.', '-');
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
    }
}

