/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.FooLogNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.proto.SoyProtoType;

final class FooLogValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind LOGGING_IS_EXPERIMENTAL = SoyErrorKind.of("The '{'foolog ...'}' command is disabled in this configuration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_CONFIG_FOR_ELEMENT = SoyErrorKind.of("Could not find logging configuration for this element.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_CONFIG = SoyErrorKind.of("Unexpected ''data'' attribute for logging element ''{0}'', there is no configured ''proto_extension_type'' in the logging configuration for this element. Did you forget to configure it?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind WRONG_TYPE = SoyErrorKind.of("Expected an expression of type ''{0}'', instead got ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REQUIRE_STRICTHTML = SoyErrorKind.of("The '{'foolog ...'}' command can only be used in templates with stricthtml=\"true\".", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter reporter;
    private final boolean enabled;
    private final ValidatedLoggingConfig loggingConfig;

    FooLogValidationPass(ErrorReporter reporter, ImmutableSet<String> experimentalFeatures, ValidatedLoggingConfig loggingConfig) {
        this.reporter = reporter;
        this.loggingConfig = loggingConfig;
        this.enabled = experimentalFeatures.contains((Object)"logging_support");
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (file.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        new FooLogVisitor().exec(file);
    }

    private final class FooLogVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private TemplateNode currentTemplate = null;

        private FooLogVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.currentTemplate = node;
            this.visitChildren(node);
            this.currentTemplate = null;
        }

        @Override
        protected void visitFooLogNode(FooLogNode node) {
            if (!FooLogValidationPass.this.enabled) {
                FooLogValidationPass.this.reporter.report(node.getSourceLocation(), LOGGING_IS_EXPERIMENTAL, new Object[0]);
            } else if (!this.currentTemplate.isStrictHtml()) {
                FooLogValidationPass.this.reporter.report(node.getName().location(), REQUIRE_STRICTHTML, new Object[0]);
            } else {
                this.validateNodeAgainstConfig(node);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private void validateNodeAgainstConfig(FooLogNode node) {
            ValidatedLoggingConfig.ValidatedLoggableElement config = FooLogValidationPass.this.loggingConfig.getElement(node.getName().identifier());
            if (config == null) {
                FooLogValidationPass.this.reporter.report(node.getName().location(), NO_CONFIG_FOR_ELEMENT, SoyErrors.getDidYouMeanMessage(FooLogValidationPass.this.loggingConfig.allKnownIdentifiers(), node.getName().identifier()));
            } else {
                SoyType type;
                node.setLoggingId(config.getId());
                if (node.getConfigExpression() != null) {
                    type = node.getConfigExpression().getType();
                    Optional<String> protoName = config.getProtoName();
                    if (!protoName.isPresent()) {
                        FooLogValidationPass.this.reporter.report(node.getConfigExpression().getSourceLocation(), UNEXPECTED_CONFIG, node.getName().identifier());
                    } else if (!(type.getKind() == SoyType.Kind.ERROR || type.getKind() == SoyType.Kind.PROTO && ((SoyProtoType)type).getDescriptor().getFullName().equals(protoName.get()))) {
                        FooLogValidationPass.this.reporter.report(node.getConfigExpression().getSourceLocation(), WRONG_TYPE, protoName.get(), type);
                    }
                }
                if (node.getLogonlyExpression() != null && (type = node.getLogonlyExpression().getType()).getKind() != SoyType.Kind.BOOL) {
                    FooLogValidationPass.this.reporter.report(node.getLogonlyExpression().getSourceLocation(), WRONG_TYPE, BoolType.getInstance(), type);
                }
            }
        }
    }
}

