/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.passes.AutoValue_ConditionalBranches_ConditionalBranch;
import com.google.template.soy.passes.Condition;
import com.google.template.soy.passes.HtmlTagEntry;
import com.google.template.soy.soytree.TagName;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class ConditionalBranches {
    private final List<ConditionalBranch> branches = new ArrayList<ConditionalBranch>();

    ConditionalBranches() {
    }

    ConditionalBranches(ConditionalBranches branches) {
        this();
        this.addAll(branches);
    }

    void clear() {
        this.branches.clear();
    }

    List<ConditionalBranch> getBranches() {
        this.removeEmptyDeque();
        return this.branches;
    }

    SourceLocation getSourceLocation() {
        this.removeEmptyDeque();
        if (this.branches.isEmpty()) {
            return SourceLocation.UNKNOWN;
        }
        ConditionalBranch branch = this.branches.get(0);
        return branch.deque().peekFirst().getSourceLocation();
    }

    public String toString() {
        return this.branches.toString();
    }

    private void removeEmptyDeque() {
        Iterator<ConditionalBranch> it = this.branches.iterator();
        while (it.hasNext()) {
            ConditionalBranch branch = it.next();
            Iterator<HtmlTagEntry> it2 = branch.deque().iterator();
            while (it2.hasNext()) {
                HtmlTagEntry entry = it2.next();
                if (entry.getBranches() == null || !entry.getBranches().isEmpty()) continue;
                it2.remove();
            }
            if (!branch.deque().isEmpty()) continue;
            it.remove();
        }
    }

    private boolean hasDefaultCond() {
        if (this.branches.isEmpty()) {
            return false;
        }
        return ((ConditionalBranch)Iterables.getLast(this.branches)).condition().isDefaultCond();
    }

    boolean hasCommonPrefix(TagName tag) {
        if (!this.hasDefaultCond()) {
            return false;
        }
        for (ConditionalBranch branch : this.branches) {
            if (branch.deque().isEmpty()) {
                return false;
            }
            HtmlTagEntry entry = branch.deque().peek();
            while (entry.hasTagName() && !entry.getTagName().equals(tag) && TagName.checkOptionalTagShouldBePopped(entry.getTagName(), tag)) {
                branch.deque().poll();
                entry = branch.deque().peek();
                if (entry != null) continue;
                return false;
            }
            if (!(entry.hasTagName() ? !entry.getTagName().equals(tag) : !entry.getBranches().hasCommonPrefix(tag))) continue;
            return false;
        }
        return true;
    }

    void popAllBranches() {
        for (ConditionalBranch branch : this.branches) {
            HtmlTagEntry entry = branch.deque().peek();
            if (entry.hasTagName()) {
                branch.deque().pop();
                continue;
            }
            entry.getBranches().popAllBranches();
        }
        this.removeEmptyDeque();
    }

    void popOptionalTags(@Nullable TagName closeTag) {
        for (ConditionalBranch branch : this.branches) {
            HtmlTagEntry.popOptionalTags(branch.deque(), closeTag);
        }
        this.removeEmptyDeque();
    }

    boolean isEmpty() {
        this.removeEmptyDeque();
        return this.branches.isEmpty();
    }

    void add(Condition condition, ArrayDeque<HtmlTagEntry> deque) {
        Preconditions.checkArgument((!condition.equals(Condition.getEmptyCondition()) ? 1 : 0) != 0, (Object)"Cannot add an empty condition into a branch. This should never happen.");
        Preconditions.checkState((!this.hasDefaultCond() ? 1 : 0) != 0, (Object)"Cannot add a new branch since the current ConditionalBranches already contains a default condition.");
        ArrayDeque<HtmlTagEntry> newDeque = new ArrayDeque<HtmlTagEntry>();
        newDeque.addAll(deque);
        this.branches.add(ConditionalBranch.create(condition.copy(), newDeque));
    }

    void addAll(ConditionalBranches branches) {
        Preconditions.checkState((!this.hasDefaultCond() ? 1 : 0) != 0, (Object)"Cannot add a new branch since the current ConditionalBranches already contain a default condition.");
        for (ConditionalBranch branch : branches.branches) {
            ArrayDeque<HtmlTagEntry> deque = branch.deque();
            ArrayDeque<HtmlTagEntry> newDeque = new ArrayDeque<HtmlTagEntry>();
            newDeque.addAll(deque);
            this.branches.add(ConditionalBranch.create(branch.condition().copy(), newDeque));
        }
    }

    static abstract class ConditionalBranch {
        ConditionalBranch() {
        }

        static ConditionalBranch create(Condition condition, ArrayDeque<HtmlTagEntry> deque) {
            return new AutoValue_ConditionalBranches_ConditionalBranch(condition, deque);
        }

        abstract Condition condition();

        abstract ArrayDeque<HtmlTagEntry> deque();
    }
}

