/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import java.util.List;

abstract class Condition {
    Condition() {
    }

    abstract Condition copy();

    abstract boolean isDefaultCond();

    static Condition getEmptyCondition() {
        return EmptyCondition.INSTANCE;
    }

    static Condition createIfCondition() {
        return new IfCondition();
    }

    static Condition createIfCondition(ExprNode expr) {
        return new IfCondition(expr);
    }

    static Condition createSwitchCondition(ExprNode switchExpr, List<ExprRootNode> caseExprs) {
        List<ExprNode> list = caseExprs;
        return new SwitchCondition(switchExpr, list);
    }

    private static final class SwitchCondition
    extends Condition {
        private final ExprNode switchExpr;
        private final ImmutableList<ExprNode> caseExprs;

        SwitchCondition(ExprNode switchExpr, List<ExprNode> caseExprs) {
            this.switchExpr = switchExpr;
            this.caseExprs = ImmutableList.copyOf(caseExprs);
        }

        @Override
        boolean isDefaultCond() {
            return this.caseExprs.isEmpty();
        }

        @Override
        Condition copy() {
            return new SwitchCondition(this.switchExpr, (List<ExprNode>)this.caseExprs);
        }

        public String toString() {
            return "SWITCH_CONDITION: " + this.switchExpr + ", CASE: " + this.caseExprs;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SwitchCondition) {
                SwitchCondition cond = (SwitchCondition)object;
                return ExprEquivalence.get().equivalent(this.switchExpr, cond.switchExpr) && ExprEquivalence.get().pairwise().equivalent(this.caseExprs, cond.caseExprs);
            }
            return false;
        }

        public int hashCode() {
            return 31 * ExprEquivalence.get().hash(this.switchExpr) + ExprEquivalence.get().pairwise().hash(this.caseExprs);
        }
    }

    private static final class IfCondition
    extends Condition {
        private final Optional<ExprNode> expr;

        IfCondition() {
            this.expr = Optional.absent();
        }

        IfCondition(ExprNode expr) {
            this.expr = Optional.of((Object)expr);
        }

        IfCondition(IfCondition condition) {
            this.expr = condition.expr.isPresent() ? Optional.of((Object)((ExprNode)condition.expr.get()).copy(new CopyState())) : Optional.absent();
        }

        @Override
        boolean isDefaultCond() {
            return !this.expr.isPresent();
        }

        @Override
        Condition copy() {
            return new IfCondition(this);
        }

        public String toString() {
            return "IF_CONDITION: " + this.expr;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IfCondition) {
                IfCondition cond = (IfCondition)object;
                return ExprEquivalence.get().equivalent(this.expr.orNull(), cond.expr.orNull());
            }
            return false;
        }

        public int hashCode() {
            return ExprEquivalence.get().hash(this.expr.orNull());
        }
    }

    private static final class EmptyCondition
    extends Condition {
        private static final EmptyCondition INSTANCE = new EmptyCondition();

        private EmptyCondition() {
        }

        @Override
        EmptyCondition copy() {
            return INSTANCE;
        }

        public String toString() {
            return "EMPTY_CONDITION";
        }

        @Override
        boolean isDefaultCond() {
            return true;
        }
    }
}

