/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.html.HtmlEscapers;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basicfunctions.DebugSoyTemplateInfoFunction;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.primitive.BoolType;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AddHtmlCommentsForDebugPass
extends CompilerFileSetPass {
    private static final String HTML_COMMENTS_PREFIX = "dta_of(%s, %s, %s)";
    private static final String HTML_COMMENTS_SUFFIX = "dta_cf(%s)";

    @Override
    public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
        Set<TemplateNode> templatesToRewrite = this.getTemplatesToRewrite(registry);
        Multimap<TemplateNode, TemplateNode> strictHtmlCallers = this.buildStrictHtmlCallers(registry);
        this.collectCallers(templatesToRewrite, strictHtmlCallers);
        this.rewriteTemplates(templatesToRewrite, fileSet.getNodeIdGenerator());
    }

    private Multimap<TemplateNode, TemplateNode> buildStrictHtmlCallers(TemplateRegistry registry) {
        LinkedHashMultimap strictHtmlCallers = LinkedHashMultimap.create();
        for (TemplateNode template : registry.getAllTemplates()) {
            if (!this.isStrictAndKindHtml(template)) continue;
            for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallNode.class)) {
                if (callNode instanceof CallBasicNode) {
                    TemplateBasicNode callee = registry.getBasicTemplate(((CallBasicNode)callNode).getCalleeName());
                    if (!this.isStrictAndKindHtml(callee)) continue;
                    strictHtmlCallers.put((Object)callee, (Object)template);
                    continue;
                }
                if (!(callNode instanceof CallDelegateNode)) continue;
                ImmutableList potentialCallees = registry.getDelTemplateSelector().delTemplateNameToValues().get((Object)((CallDelegateNode)callNode).getDelCalleeName());
                for (TemplateDelegateNode callee : potentialCallees) {
                    if (!this.isStrictAndKindHtml(callee)) continue;
                    strictHtmlCallers.put((Object)callee, (Object)template);
                }
            }
        }
        return strictHtmlCallers;
    }

    private Set<TemplateNode> getTemplatesToRewrite(TemplateRegistry registry) {
        LinkedHashSet templatesToRewrite = Sets.newLinkedHashSet();
        for (TemplateNode template : registry.getAllTemplates()) {
            if (!this.isStrictAndKindHtml(template) || !this.hasHtmlParamOrNode(template)) continue;
            templatesToRewrite.add(template);
        }
        return templatesToRewrite;
    }

    private void collectCallers(Set<TemplateNode> templatesToRewrite, Multimap<TemplateNode, TemplateNode> strictHtmlCallers) {
        ArrayDeque<TemplateNode> queue = new ArrayDeque<TemplateNode>();
        queue.addAll(templatesToRewrite);
        while (!queue.isEmpty()) {
            TemplateNode node = (TemplateNode)queue.poll();
            for (TemplateNode caller : strictHtmlCallers.get((Object)node)) {
                if (!templatesToRewrite.add(caller)) continue;
                queue.add(caller);
            }
        }
    }

    private void rewriteTemplates(Set<TemplateNode> templatesToRewrite, IdGenerator nodeIdGen) {
        for (TemplateNode node : templatesToRewrite) {
            String templateName = AddHtmlCommentsForDebugPass.getTemplateName(node);
            SourceLocation insertLocation = node.getSourceLocation();
            node.addChild(0, this.createSoyDebug(insertLocation, nodeIdGen, String.format(HTML_COMMENTS_PREFIX, templateName, insertLocation.getFilePath(), insertLocation.getBeginLine())));
            node.addChild(this.createSoyDebug(insertLocation, nodeIdGen, String.format(HTML_COMMENTS_SUFFIX, templateName)));
        }
    }

    private static String getTemplateName(TemplateNode node) {
        if (node instanceof TemplateDelegateNode) {
            return ((TemplateDelegateNode)node).getDelTemplateName();
        }
        return node.getTemplateName();
    }

    private IfNode createSoyDebug(SourceLocation insertionLocation, IdGenerator nodeIdGen, String htmlComment) {
        IfNode ifNode = new IfNode(nodeIdGen.genId(), insertionLocation);
        FunctionNode funcNode = new FunctionNode("$$debugSoyTemplateInfo", insertionLocation);
        funcNode.setSoyFunction(DebugSoyTemplateInfoFunction.INSTANCE);
        funcNode.setType(BoolType.getInstance());
        IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), insertionLocation, "if", funcNode);
        HtmlCommentNode htmlCommentNode = new HtmlCommentNode(nodeIdGen.genId(), insertionLocation);
        htmlCommentNode.addChild(new RawTextNode(nodeIdGen.genId(), HtmlEscapers.htmlEscaper().escape(htmlComment), insertionLocation));
        ifCondNode.addChild(htmlCommentNode);
        ifNode.addChild(ifCondNode);
        return ifNode;
    }

    private boolean hasHtmlParamOrNode(TemplateNode node) {
        for (TemplateParam param : node.getParams()) {
            if (param.type().getKind() != SoyType.Kind.HTML) continue;
            return true;
        }
        return SoyTreeUtils.hasNodesOfType(node, HtmlOpenTagNode.class, HtmlCloseTagNode.class, HtmlCommentNode.class);
    }

    private boolean isStrictAndKindHtml(TemplateNode node) {
        return node != null && node.getContentKind() == SanitizedContentKind.HTML && node.getAutoescapeMode() == AutoescapeMode.STRICT;
    }
}

