/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Rewriter {
    private final Inferences inferences;
    private final Set<String> visitedTemplateNames = Sets.newHashSet();
    private final Map<String, SanitizedContentKind> sanitizedContentOperators;

    Rewriter(Inferences inferences, Map<String, SanitizedContentKind> sanitizedContentOperators) {
        this.inferences = inferences;
        this.sanitizedContentOperators = sanitizedContentOperators;
    }

    public List<TemplateNode> rewrite(SoyFileSetNode files) {
        RewriterVisitor mutator = new RewriterVisitor();
        for (SoyFileNode file : files.getChildren()) {
            mutator.exec(file);
        }
        ImmutableList.Builder extraTemplates = ImmutableList.builder();
        for (TemplateNode template : this.inferences.getAllTemplates()) {
            String name = template.getTemplateName();
            if (this.visitedTemplateNames.contains(name)) continue;
            extraTemplates.add((Object)template);
            mutator.exec(template);
        }
        return extraTemplates.build();
    }

    private final class RewriterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private RewriterVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            boolean firstTime = Rewriter.this.visitedTemplateNames.add(templateNode.getTemplateName());
            Preconditions.checkState((boolean)firstTime, (String)"already visited: %s", (Object)templateNode.getTemplateName());
            this.visitChildrenAllowingConcurrentModification(templateNode);
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            ImmutableList<EscapingMode> escapingModes = Rewriter.this.inferences.getEscapingModesForNode(printNode);
            for (EscapingMode escapingMode : escapingModes) {
                int newPrintDirectiveIndex;
                PrintDirectiveNode newPrintDirective = new PrintDirectiveNode(Rewriter.this.inferences.getIdGenerator().genId(), printNode.getSourceLocation(), escapingMode.directiveName, (ImmutableList<ExprNode>)ImmutableList.of());
                for (newPrintDirectiveIndex = printNode.numChildren(); newPrintDirectiveIndex > 0; --newPrintDirectiveIndex) {
                    String printDirectiveName = ((PrintDirectiveNode)printNode.getChild(newPrintDirectiveIndex - 1)).getName();
                    SanitizedContentKind contentKind = (SanitizedContentKind)((Object)Rewriter.this.sanitizedContentOperators.get(printDirectiveName));
                    if (contentKind == null || contentKind != escapingMode.contentKind) break;
                }
                printNode.addChild(newPrintDirectiveIndex, newPrintDirective);
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
        }

        private ImmutableList<String> getDirectiveNamesForNode(SoyNode node) {
            ImmutableList.Builder escapingDirectiveNames = new ImmutableList.Builder();
            for (EscapingMode escapingMode : Rewriter.this.inferences.getEscapingModesForNode(node)) {
                escapingDirectiveNames.add((Object)escapingMode.directiveName);
            }
            return escapingDirectiveNames.build();
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            node.setEscapingDirectiveNames(this.getDirectiveNamesForNode(node));
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            String derivedCalleeName = Rewriter.this.inferences.getDerivedCalleeNameForCall(node);
            if (derivedCalleeName != null) {
                if (node instanceof CallBasicNode) {
                    CallBasicNode cast = (CallBasicNode)node;
                    cast.setNewCalleeName(derivedCalleeName);
                } else {
                    ((CallDelegateNode)node).setDelCalleeName(derivedCalleeName);
                }
            }
            node.setEscapingDirectiveNames(this.getDirectiveNamesForNode(node));
            this.visitChildrenAllowingConcurrentModification(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

