/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.jssrc.dsl.AutoValue_StatementList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;

abstract class StatementList
extends CodeChunk {
    private static final StatementList EMPTY = new AutoValue_StatementList((ImmutableList<? extends CodeChunk>)ImmutableList.of());

    StatementList() {
    }

    abstract ImmutableList<? extends CodeChunk> statements();

    static StatementList of(Iterable<? extends CodeChunk> statements) {
        if (Iterables.isEmpty(statements)) {
            return EMPTY;
        }
        ImmutableList.Builder unrolled = ImmutableList.builder();
        for (CodeChunk codeChunk : statements) {
            if (codeChunk instanceof StatementList) {
                unrolled.addAll(((StatementList)codeChunk).statements());
                continue;
            }
            unrolled.add((Object)codeChunk);
        }
        return new AutoValue_StatementList((ImmutableList<? extends CodeChunk>)unrolled.build());
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk statement : this.statements()) {
            statement.collectRequires(collector);
        }
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk statement : this.statements()) {
            ctx.appendAll(statement);
        }
    }
}

